/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.matcher.argument;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.AbstractConditionMatcher;
import org.apache.dubbo.rpc.model.ModuleModel;

@Activate
public class ArgumentConditionMatcher
extends AbstractConditionMatcher {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ArgumentConditionMatcher.class);
    private static final Pattern ARGUMENTS_PATTERN = Pattern.compile("arguments\\[([0-9]+)\\]");

    public ArgumentConditionMatcher(String key, ModuleModel model) {
        super(key, model);
    }

    @Override
    public String getValue(Map<String, String> sample, URL url, Invocation invocation) {
        try {
            String[] expressArray = this.key.split("\\.");
            String argumentExpress = expressArray[0];
            Matcher matcher = ARGUMENTS_PATTERN.matcher(argumentExpress);
            if (!matcher.find()) {
                return "dubbo_internal_not_found_argument_condition_value";
            }
            int index = Integer.parseInt(matcher.group(1));
            if (index < 0 || index > invocation.getArguments().length) {
                return "dubbo_internal_not_found_argument_condition_value";
            }
            return String.valueOf(invocation.getArguments()[index]);
        }
        catch (Exception e) {
            logger.warn("2-7", "Parse argument match condition failed", "", "Invalid , will ignore., ", (Throwable)e);
            return "dubbo_internal_not_found_argument_condition_value";
        }
    }
}

