/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.directory.StaticDirectory;
import org.apache.dubbo.rpc.listener.ExporterChangeListener;
import org.apache.dubbo.rpc.listener.InjvmExporterListener;
import org.apache.dubbo.rpc.support.RpcUtils;

public class ScopeClusterInvoker<T>
implements ClusterInvoker<T>,
ExporterChangeListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ScopeClusterInvoker.class);
    private final Object createLock = new Object();
    private Protocol protocolSPI;
    private final Directory<T> directory;
    private final Invoker<T> invoker;
    private final AtomicBoolean isExported;
    private volatile Invoker<T> injvmInvoker;
    private volatile InjvmExporterListener injvmExporterListener;
    private boolean peerFlag;
    private boolean injvmFlag;

    public ScopeClusterInvoker(Directory<T> directory, Invoker<T> invoker) {
        this.directory = directory;
        this.invoker = invoker;
        this.isExported = new AtomicBoolean(false);
        this.init();
    }

    public URL getUrl() {
        return this.directory.getConsumerUrl();
    }

    @Override
    public URL getRegistryUrl() {
        return this.directory.getUrl();
    }

    @Override
    public Directory<T> getDirectory() {
        return this.directory;
    }

    @Override
    public boolean isDestroyed() {
        return this.directory.isDestroyed();
    }

    public boolean isAvailable() {
        if (this.peerFlag || this.isBroadcast()) {
            return this.invoker.isAvailable();
        }
        if (this.injvmFlag && this.isForceLocal()) {
            return this.isExported.get();
        }
        if (this.injvmFlag && this.isExported.get()) {
            return true;
        }
        return this.invoker.isAvailable();
    }

    public void destroy() {
        if (this.injvmExporterListener != null) {
            this.injvmExporterListener.removeExporterChangeListener((ExporterChangeListener)this, this.getUrl().getServiceKey());
        }
        this.destroyInjvmInvoker();
        this.invoker.destroy();
    }

    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    public Result invoke(Invocation invocation) throws RpcException {
        if (this.isBroadcast()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing broadcast call for method: " + RpcUtils.getMethodName((Invocation)invocation) + " of service: " + this.getUrl().getServiceKey());
            }
            return this.invoker.invoke(invocation);
        }
        if (this.peerFlag) {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing point-to-point call for method: " + RpcUtils.getMethodName((Invocation)invocation) + " of service: " + this.getUrl().getServiceKey());
            }
            return this.invoker.invoke(invocation);
        }
        if (this.isInjvmExported()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Performing local JVM call for method: " + RpcUtils.getMethodName((Invocation)invocation) + " of service: " + this.getUrl().getServiceKey());
            }
            return this.injvmInvoker.invoke(invocation);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Performing remote call for method: " + RpcUtils.getMethodName((Invocation)invocation) + " of service: " + this.getUrl().getServiceKey());
        }
        return this.invoker.invoke(invocation);
    }

    private boolean isBroadcast() {
        return "broadcast".equalsIgnoreCase(this.getUrl().getParameter("cluster"));
    }

    public void onExporterChangeExport(Exporter<?> exporter) {
        if (this.isExported.get()) {
            return;
        }
        if (this.getUrl().getServiceKey().equals(exporter.getInvoker().getUrl().getServiceKey()) && exporter.getInvoker().getUrl().getProtocol().equalsIgnoreCase("injvm")) {
            this.createInjvmInvoker(exporter);
            this.isExported.compareAndSet(false, true);
        }
    }

    public void onExporterChangeUnExport(Exporter<?> exporter) {
        if (this.getUrl().getServiceKey().equals(exporter.getInvoker().getUrl().getServiceKey()) && exporter.getInvoker().getUrl().getProtocol().equalsIgnoreCase("injvm")) {
            this.destroyInjvmInvoker();
            this.isExported.compareAndSet(true, false);
        }
    }

    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    private void init() {
        Boolean peer = (Boolean)this.getUrl().getAttribute("peer");
        String isInjvm = this.getUrl().getParameter("injvm");
        if (peer != null && peer.booleanValue()) {
            this.peerFlag = true;
            return;
        }
        if (this.injvmInvoker == null && "injvm".equalsIgnoreCase(this.getRegistryUrl().getProtocol())) {
            this.injvmInvoker = this.invoker;
            this.isExported.compareAndSet(false, true);
            this.injvmFlag = true;
            return;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(isInjvm) || "local".equalsIgnoreCase(this.getUrl().getParameter("scope"))) {
            this.injvmFlag = true;
        } else if (isInjvm == null) {
            this.injvmFlag = this.isNotRemoteOrGeneric();
        }
        this.protocolSPI = (Protocol)this.getUrl().getApplicationModel().getExtensionLoader(Protocol.class).getAdaptiveExtension();
        this.injvmExporterListener = (InjvmExporterListener)this.getUrl().getOrDefaultFrameworkModel().getBeanFactory().getBean(InjvmExporterListener.class);
        this.injvmExporterListener.addExporterChangeListener((ExporterChangeListener)this, this.getUrl().getServiceKey());
    }

    private boolean isNotRemoteOrGeneric() {
        return !"remote".equalsIgnoreCase(this.getUrl().getParameter("scope")) && !this.getUrl().getParameter("generic", false);
    }

    private boolean isInjvmExported() {
        boolean localOnce;
        Boolean localInvoke = RpcContext.getServiceContext().getLocalInvoke();
        boolean isExportedValue = this.isExported.get();
        boolean bl = localOnce = localInvoke != null && localInvoke != false;
        if (isExportedValue && localOnce) {
            return true;
        }
        if (localInvoke != null && !localInvoke.booleanValue()) {
            return false;
        }
        if (!isExportedValue && (this.isForceLocal() || localOnce)) {
            throw new RpcException("Local service for " + this.getUrl().getServiceInterface() + " has not been exposed yet!");
        }
        return isExportedValue && this.injvmFlag;
    }

    private boolean isForceLocal() {
        return "local".equalsIgnoreCase(this.getUrl().getParameter("scope")) || Boolean.TRUE.toString().equalsIgnoreCase(this.getUrl().getParameter("injvm"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInjvmInvoker(Exporter<?> exporter) {
        if (this.injvmInvoker == null) {
            Object object = this.createLock;
            synchronized (object) {
                if (this.injvmInvoker == null) {
                    ServiceConfigURL url = new ServiceConfigURL("injvm", NetUtils.getLocalHost(), this.getUrl().getPort(), this.getInterface().getName(), this.getUrl().getParameters());
                    url = url.setScopeModel(this.getUrl().getScopeModel());
                    url = url.setServiceModel(this.getUrl().getServiceModel());
                    DubboServiceAddressURL consumerUrl = new DubboServiceAddressURL(url.getUrlAddress(), url.getUrlParam(), exporter.getInvoker().getUrl(), null);
                    Invoker invoker = this.protocolSPI.refer(this.getInterface(), (URL)consumerUrl);
                    ArrayList invokers = new ArrayList();
                    invokers.add(invoker);
                    this.injvmInvoker = Cluster.getCluster(url.getScopeModel(), "failover", false).join(new StaticDirectory((URL)url, invokers), true);
                }
            }
        }
    }

    private void destroyInjvmInvoker() {
        if (this.injvmInvoker != null) {
            this.injvmInvoker.destroy();
            this.injvmInvoker = null;
        }
    }

    public String toString() {
        return "ScopeClusterInvoker{directory=" + this.directory + ", isExported=" + this.isExported + ", peerFlag=" + this.peerFlag + ", injvmFlag=" + this.injvmFlag + '}';
    }
}

