/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.filter;

import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Activate(value={"auth"}, order=-20000)
public class ProviderAuthHeaderFilter
implements HeaderFilter {
    private final FrameworkModel frameworkModel;

    public ProviderAuthHeaderFilter(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public RpcInvocation invoke(Invoker<?> invoker, RpcInvocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        boolean shouldAuth = url.getParameter("auth", false);
        if (shouldAuth) {
            Authenticator authenticator = (Authenticator)this.frameworkModel.getExtensionLoader(Authenticator.class).getExtension(url.getParameter("authenticator", "basic"));
            try {
                authenticator.authenticate((Invocation)invocation, url);
            }
            catch (Exception e) {
                throw new RpcException(13, "No Auth.");
            }
            invocation.getAttributes().put("auth.success", Boolean.TRUE);
        }
        return invocation;
    }
}

