/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AuthConfig {
    public static final String DRUID_AUTHENTICATION_RESULT = "Druid-Authentication-Result";
    public static final String DRUID_AUTHORIZATION_CHECKED = "Druid-Authorization-Checked";
    public static final String DRUID_ALLOW_UNSECURED_PATH = "Druid-Allow-Unsecured-Path";
    public static final String ALLOW_ALL_NAME = "allowAll";
    public static final String ANONYMOUS_NAME = "anonymous";
    public static final String TRUSTED_DOMAIN_NAME = "trustedDomain";
    @JsonProperty
    private final List<String> authenticatorChain;
    @JsonProperty
    private final List<String> authorizers;
    @JsonProperty
    private final List<String> unsecuredPaths;
    @JsonProperty
    private final boolean allowUnauthenticatedHttpOptions;
    @JsonProperty
    private final boolean authorizeQueryContextParams;

    public AuthConfig() {
        this(null, null, null, false, false);
    }

    @JsonCreator
    public AuthConfig(@JsonProperty(value="authenticatorChain") List<String> authenticatorChain, @JsonProperty(value="authorizers") List<String> authorizers, @JsonProperty(value="unsecuredPaths") List<String> unsecuredPaths, @JsonProperty(value="allowUnauthenticatedHttpOptions") boolean allowUnauthenticatedHttpOptions, @JsonProperty(value="authorizeQueryContextParams") boolean authorizeQueryContextParams) {
        this.authenticatorChain = authenticatorChain;
        this.authorizers = authorizers;
        this.unsecuredPaths = unsecuredPaths == null ? Collections.emptyList() : unsecuredPaths;
        this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
        this.authorizeQueryContextParams = authorizeQueryContextParams;
    }

    public List<String> getAuthenticatorChain() {
        return this.authenticatorChain;
    }

    public List<String> getAuthorizers() {
        return this.authorizers;
    }

    public List<String> getUnsecuredPaths() {
        return this.unsecuredPaths;
    }

    public boolean isAllowUnauthenticatedHttpOptions() {
        return this.allowUnauthenticatedHttpOptions;
    }

    public boolean authorizeQueryContextParams() {
        return this.authorizeQueryContextParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthConfig that = (AuthConfig)o;
        return this.allowUnauthenticatedHttpOptions == that.allowUnauthenticatedHttpOptions && this.authorizeQueryContextParams == that.authorizeQueryContextParams && Objects.equals(this.authenticatorChain, that.authenticatorChain) && Objects.equals(this.authorizers, that.authorizers) && Objects.equals(this.unsecuredPaths, that.unsecuredPaths);
    }

    public int hashCode() {
        return Objects.hash(this.authenticatorChain, this.authorizers, this.unsecuredPaths, this.allowUnauthenticatedHttpOptions, this.authorizeQueryContextParams);
    }

    public String toString() {
        return "AuthConfig{authenticatorChain=" + this.authenticatorChain + ", authorizers=" + this.authorizers + ", unsecuredPaths=" + this.unsecuredPaths + ", allowUnauthenticatedHttpOptions=" + this.allowUnauthenticatedHttpOptions + ", enableQueryContextAuthorization=" + this.authorizeQueryContextParams + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> authenticatorChain;
        private List<String> authorizers;
        private List<String> unsecuredPaths;
        private boolean allowUnauthenticatedHttpOptions;
        private boolean authorizeQueryContextParams;

        public Builder setAuthenticatorChain(List<String> authenticatorChain) {
            this.authenticatorChain = authenticatorChain;
            return this;
        }

        public Builder setAuthorizers(List<String> authorizers) {
            this.authorizers = authorizers;
            return this;
        }

        public Builder setUnsecuredPaths(List<String> unsecuredPaths) {
            this.unsecuredPaths = unsecuredPaths;
            return this;
        }

        public Builder setAllowUnauthenticatedHttpOptions(boolean allowUnauthenticatedHttpOptions) {
            this.allowUnauthenticatedHttpOptions = allowUnauthenticatedHttpOptions;
            return this;
        }

        public Builder setAuthorizeQueryContextParams(boolean authorizeQueryContextParams) {
            this.authorizeQueryContextParams = authorizeQueryContextParams;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.authenticatorChain, this.authorizers, this.unsecuredPaths, this.allowUnauthenticatedHttpOptions, this.authorizeQueryContextParams);
        }
    }
}

