/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;

public class AuthenticatorMapperModule
implements DruidModule {
    private static final String AUTHENTICATOR_PROPERTIES_FORMAT_STRING = "druid.auth.authenticator.%s";

    public void configure(Binder binder) {
        binder.bind(AuthenticatorMapper.class).toProvider((Provider)new AuthenticatorMapperProvider()).in(LazySingleton.class);
        LifecycleModule.register((Binder)binder, AuthenticatorMapper.class);
    }

    private static void validateAuthenticators(List<String> authenticators) {
        if (authenticators == null) {
            return;
        }
        if (authenticators.isEmpty()) {
            throw new IAE("Must have at least one Authenticator configured.", new Object[0]);
        }
        HashSet<String> authenticatorSet = new HashSet<String>();
        for (String authenticator : authenticators) {
            if (authenticatorSet.contains(authenticator)) {
                throw new ISE("Cannot have multiple authenticators with the same name: [%s]", new Object[]{authenticator});
            }
            authenticatorSet.add(authenticator);
        }
    }

    private static class AuthenticatorMapperProvider
    implements Provider<AuthenticatorMapper> {
        private AuthConfig authConfig;
        private Injector injector;
        private Properties props;
        private JsonConfigurator configurator;

        private AuthenticatorMapperProvider() {
        }

        @Inject
        public void inject(Injector injector, Properties props, JsonConfigurator configurator) {
            this.authConfig = (AuthConfig)injector.getInstance(AuthConfig.class);
            this.injector = injector;
            this.props = props;
            this.configurator = configurator;
        }

        public AuthenticatorMapper get() {
            LinkedHashMap authenticatorMap = Maps.newLinkedHashMap();
            List<String> authenticators = this.authConfig.getAuthenticatorChain();
            AuthenticatorMapperModule.validateAuthenticators(authenticators);
            if (authenticators == null) {
                authenticatorMap.put("allowAll", new AllowAllAuthenticator());
                return new AuthenticatorMapper(authenticatorMap);
            }
            for (String authenticatorName : authenticators) {
                String authenticatorPropertyBase = StringUtils.format((String)AuthenticatorMapperModule.AUTHENTICATOR_PROPERTIES_FORMAT_STRING, (Object[])new Object[]{authenticatorName});
                JsonConfigProvider authenticatorProvider = JsonConfigProvider.of((String)authenticatorPropertyBase, Authenticator.class);
                Properties adjustedProps = new Properties(this.props);
                String nameProperty = StringUtils.format((String)"druid.auth.authenticator.%s.name", (Object[])new Object[]{authenticatorName});
                if (adjustedProps.containsKey(nameProperty)) {
                    throw new IAE("Name property [%s] is reserved.", new Object[]{nameProperty});
                }
                adjustedProps.put(nameProperty, authenticatorName);
                authenticatorProvider.inject(adjustedProps, this.configurator);
                Supplier authenticatorSupplier = authenticatorProvider.get();
                if (authenticatorSupplier == null) {
                    throw new ISE("Could not create authenticator with name: %s", new Object[]{authenticatorName});
                }
                Authenticator authenticator = (Authenticator)authenticatorSupplier.get();
                authenticatorMap.put(authenticatorName, authenticator);
            }
            return new AuthenticatorMapper(authenticatorMap);
        }
    }
}

