/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.http.security.ConfigResourceFilter;

@Path(value="/druid/coordinator/v1/config/compaction")
@ResourceFilters(value={ConfigResourceFilter.class})
public class CoordinatorCompactionConfigsResource {
    private static final Logger LOG = new Logger(CoordinatorCompactionConfigsResource.class);
    private static final long UPDATE_RETRY_DELAY = 1000L;
    static final int UPDATE_NUM_RETRY = 5;
    private final JacksonConfigManager manager;
    private final MetadataStorageConnector connector;
    private final MetadataStorageTablesConfig connectorConfig;

    @Inject
    public CoordinatorCompactionConfigsResource(JacksonConfigManager manager, MetadataStorageConnector connector, MetadataStorageTablesConfig connectorConfig) {
        this.manager = manager;
        this.connector = connector;
        this.connectorConfig = connectorConfig;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCompactionConfig() {
        return Response.ok((Object)CoordinatorCompactionConfig.current(this.manager)).build();
    }

    @POST
    @Path(value="/taskslots")
    @Consumes(value={"application/json"})
    public Response setCompactionTaskLimit(@QueryParam(value="ratio") Double compactionTaskSlotRatio, @QueryParam(value="max") Integer maxCompactionTaskSlots, @QueryParam(value="useAutoScaleSlots") Boolean useAutoScaleSlots, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        Callable<ConfigManager.SetResult> callable = () -> {
            byte[] currentBytes = this.getCurrentConfigInByteFromDb();
            CoordinatorCompactionConfig current = CoordinatorCompactionConfig.convertByteToConfig(this.manager, currentBytes);
            CoordinatorCompactionConfig newCompactionConfig = CoordinatorCompactionConfig.from(current, compactionTaskSlotRatio, maxCompactionTaskSlots, useAutoScaleSlots);
            return this.manager.set("coordinator.compaction.config", currentBytes, (Object)newCompactionConfig, new AuditInfo(author, comment, req.getRemoteAddr()));
        };
        return this.updateConfigHelper(callable);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addOrUpdateCompactionConfig(DataSourceCompactionConfig newConfig, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        Callable<ConfigManager.SetResult> callable = () -> {
            byte[] currentBytes = this.getCurrentConfigInByteFromDb();
            CoordinatorCompactionConfig current = CoordinatorCompactionConfig.convertByteToConfig(this.manager, currentBytes);
            Map newConfigs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
            newConfigs.put(newConfig.getDataSource(), newConfig);
            CoordinatorCompactionConfig newCompactionConfig = CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(newConfigs.values()));
            return this.manager.set("coordinator.compaction.config", currentBytes, (Object)newCompactionConfig, new AuditInfo(author, comment, req.getRemoteAddr()));
        };
        return this.updateConfigHelper(callable);
    }

    @GET
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response getCompactionConfig(@PathParam(value="dataSource") String dataSource) {
        CoordinatorCompactionConfig current = CoordinatorCompactionConfig.current(this.manager);
        Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.get(dataSource);
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)config).build();
    }

    @DELETE
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response deleteCompactionConfig(@PathParam(value="dataSource") String dataSource, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        Callable<ConfigManager.SetResult> callable = () -> {
            byte[] currentBytes = this.getCurrentConfigInByteFromDb();
            CoordinatorCompactionConfig current = CoordinatorCompactionConfig.convertByteToConfig(this.manager, currentBytes);
            Map configs = current.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)configs.remove(dataSource);
            if (config == null) {
                return ConfigManager.SetResult.fail((Exception)new NoSuchElementException("datasource not found"), (boolean)false);
            }
            return this.manager.set("coordinator.compaction.config", currentBytes, (Object)CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(configs.values())), new AuditInfo(author, comment, req.getRemoteAddr()));
        };
        return this.updateConfigHelper(callable);
    }

    @VisibleForTesting
    Response updateConfigHelper(Callable<ConfigManager.SetResult> updateMethod) {
        ConfigManager.SetResult setResult = null;
        try {
            for (int attemps = 0; attemps < 5 && !(setResult = updateMethod.call()).isOk() && setResult.isRetryable(); ++attemps) {
                this.updateRetryDelay();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Update compaction config failed", new Object[0]);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ImmutableMap.of((Object)"error", (Object)this.createErrorMessage(e))).build();
        }
        if (setResult.isOk()) {
            return Response.ok().build();
        }
        if (setResult.getException() instanceof NoSuchElementException) {
            LOG.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LOG.warn((Throwable)setResult.getException(), "Update compaction config failed", new Object[0]);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)this.createErrorMessage(setResult.getException()))).build();
    }

    private void updateRetryDelay() {
        try {
            Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private byte[] getCurrentConfigInByteFromDb() {
        return CoordinatorCompactionConfig.getConfigInByteFromDb(this.connector, this.connectorConfig);
    }

    private String createErrorMessage(Exception e) {
        if (e.getMessage() == null) {
            return "Unknown Error";
        }
        return e.getMessage();
    }
}

