/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.server.coordinator.CompactionStatistics;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.duty.CompactionSegmentIterator;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.Streams;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class NewestSegmentFirstIterator
implements CompactionSegmentIterator {
    private static final Logger log = new Logger(NewestSegmentFirstIterator.class);
    private final ObjectMapper objectMapper;
    private final Map<String, DataSourceCompactionConfig> compactionConfigs;
    private final Map<String, CompactionStatistics> compactedSegments = new HashMap<String, CompactionStatistics>();
    private final Map<String, CompactionStatistics> skippedSegments = new HashMap<String, CompactionStatistics>();
    private final Map<String, CompactibleTimelineObjectHolderCursor> timelineIterators;
    private final Map<String, Set<Interval>> intervalCompactedForDatasource = new HashMap<String, Set<Interval>>();
    private final PriorityQueue<QueueEntry> queue = new PriorityQueue((o1, o2) -> Comparators.intervalsByStartThenEnd().compare(((QueueEntry)o2).interval, ((QueueEntry)o1).interval));

    NewestSegmentFirstIterator(ObjectMapper objectMapper, Map<String, DataSourceCompactionConfig> compactionConfigs, Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources, Map<String, List<Interval>> skipIntervals) {
        this.objectMapper = objectMapper;
        this.compactionConfigs = compactionConfigs;
        this.timelineIterators = Maps.newHashMapWithExpectedSize((int)dataSources.size());
        dataSources.forEach((dataSource, timeline) -> {
            DataSourceCompactionConfig config = (DataSourceCompactionConfig)compactionConfigs.get(dataSource);
            Granularity configuredSegmentGranularity = null;
            if (config != null && !timeline.isEmpty()) {
                List<Interval> searchIntervals;
                VersionedIntervalTimeline originalTimeline = null;
                if (config.getGranularitySpec() != null && config.getGranularitySpec().getSegmentGranularity() != null) {
                    String temporaryVersion = DateTimes.nowUtc().toString();
                    HashMap<Interval, Set> intervalToPartitionMap = new HashMap<Interval, Set>();
                    configuredSegmentGranularity = config.getGranularitySpec().getSegmentGranularity();
                    VersionedIntervalTimeline timelineWithConfiguredSegmentGranularity = new VersionedIntervalTimeline(Comparator.naturalOrder());
                    Set segments = timeline.findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE);
                    for (DataSegment dataSegment : segments) {
                        for (Interval interval : configuredSegmentGranularity.getIterable(dataSegment.getInterval())) {
                            intervalToPartitionMap.computeIfAbsent(interval, k -> new HashSet()).add(dataSegment);
                        }
                    }
                    for (Map.Entry entry : intervalToPartitionMap.entrySet()) {
                        Interval interval = (Interval)entry.getKey();
                        int partitionNum = 0;
                        Set segmentSet = (Set)entry.getValue();
                        int partitions = segmentSet.size();
                        for (DataSegment segment : segmentSet) {
                            DataSegment segmentsForCompact = segment.withShardSpec((ShardSpec)new NumberedShardSpec(partitionNum, partitions));
                            timelineWithConfiguredSegmentGranularity.add(interval, (Object)temporaryVersion, (PartitionChunk)NumberedPartitionChunk.make((int)partitionNum, (int)partitions, (Object)segmentsForCompact));
                            ++partitionNum;
                        }
                    }
                    originalTimeline = timeline;
                    timeline = timelineWithConfiguredSegmentGranularity;
                }
                if (!(searchIntervals = this.findInitialSearchInterval((String)dataSource, (VersionedIntervalTimeline<String, DataSegment>)timeline, config.getSkipOffsetFromLatest(), configuredSegmentGranularity, (List)skipIntervals.get(dataSource))).isEmpty()) {
                    this.timelineIterators.put((String)dataSource, new CompactibleTimelineObjectHolderCursor((VersionedIntervalTimeline<String, DataSegment>)timeline, searchIntervals, originalTimeline));
                }
            }
        });
        compactionConfigs.forEach((dataSourceName, config) -> {
            if (config == null) {
                throw new ISE("Unknown dataSource[%s]", new Object[]{dataSourceName});
            }
            this.updateQueue((String)dataSourceName, (DataSourceCompactionConfig)config);
        });
    }

    @Override
    public Map<String, CompactionStatistics> totalCompactedStatistics() {
        return this.compactedSegments;
    }

    @Override
    public Map<String, CompactionStatistics> totalSkippedStatistics() {
        return this.skippedSegments;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public List<DataSegment> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QueueEntry entry = this.queue.poll();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        List resultSegments = entry.segments;
        Preconditions.checkState((!resultSegments.isEmpty() ? 1 : 0) != 0, (Object)"Queue entry must not be empty");
        String dataSource = ((DataSegment)resultSegments.get(0)).getDataSource();
        this.updateQueue(dataSource, this.compactionConfigs.get(dataSource));
        return resultSegments;
    }

    private void updateQueue(String dataSourceName, DataSourceCompactionConfig config) {
        CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor = this.timelineIterators.get(dataSourceName);
        if (compactibleTimelineObjectHolderCursor == null) {
            log.warn("Cannot find timeline for dataSource[%s]. Skip this dataSource", new Object[]{dataSourceName});
            return;
        }
        SegmentsToCompact segmentsToCompact = this.findSegmentsToCompact(dataSourceName, compactibleTimelineObjectHolderCursor, config);
        if (!segmentsToCompact.isEmpty()) {
            this.queue.add(new QueueEntry(segmentsToCompact.segments));
        }
    }

    @VisibleForTesting
    static PartitionsSpec findPartitionsSpecFromConfig(ClientCompactionTaskQueryTuningConfig tuningConfig) {
        PartitionsSpec partitionsSpecFromTuningConfig = tuningConfig.getPartitionsSpec();
        if (partitionsSpecFromTuningConfig instanceof DynamicPartitionsSpec) {
            return new DynamicPartitionsSpec(partitionsSpecFromTuningConfig.getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)partitionsSpecFromTuningConfig).getMaxTotalRowsOr(Long.MAX_VALUE)));
        }
        long maxTotalRows = tuningConfig.getMaxTotalRows() != null ? tuningConfig.getMaxTotalRows() : Long.MAX_VALUE;
        return partitionsSpecFromTuningConfig == null ? new DynamicPartitionsSpec(tuningConfig.getMaxRowsPerSegment(), Long.valueOf(maxTotalRows)) : partitionsSpecFromTuningConfig;
    }

    private boolean needsCompaction(DataSourceCompactionConfig config, SegmentsToCompact candidates) {
        Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0, (Object)"Empty candidates");
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from(config.getTuningConfig(), config.getMaxRowsPerSegment(), null);
        PartitionsSpec partitionsSpecFromConfig = NewestSegmentFirstIterator.findPartitionsSpecFromConfig(tuningConfig);
        CompactionState lastCompactionState = ((DataSegment)candidates.segments.get(0)).getLastCompactionState();
        if (lastCompactionState == null) {
            log.info("Candidate segment[%s] is not compacted yet. Needs compaction.", new Object[]{((DataSegment)candidates.segments.get(0)).getId()});
            return true;
        }
        boolean allCandidatesHaveSameLastCompactionState = candidates.segments.stream().allMatch(segment -> lastCompactionState.equals((Object)segment.getLastCompactionState()));
        if (!allCandidatesHaveSameLastCompactionState) {
            log.info("[%s] Candidate segments were compacted with different partitions spec. Needs compaction.", new Object[]{candidates.segments.size()});
            log.debugSegments((Collection)candidates.segments, "Candidate segments compacted with different partiton spec");
            return true;
        }
        PartitionsSpec segmentPartitionsSpec = lastCompactionState.getPartitionsSpec();
        IndexSpec segmentIndexSpec = (IndexSpec)this.objectMapper.convertValue((Object)lastCompactionState.getIndexSpec(), IndexSpec.class);
        IndexSpec configuredIndexSpec = tuningConfig.getIndexSpec() == null ? new IndexSpec() : tuningConfig.getIndexSpec();
        if (!Objects.equals(partitionsSpecFromConfig, segmentPartitionsSpec)) {
            log.info("Configured partitionsSpec[%s] is differenet from the partitionsSpec[%s] of segments. Needs compaction.", new Object[]{partitionsSpecFromConfig, segmentPartitionsSpec});
            return true;
        }
        if (!segmentIndexSpec.equals((Object)configuredIndexSpec)) {
            log.info("Configured indexSpec[%s] is different from the one[%s] of segments. Needs compaction", new Object[]{configuredIndexSpec, segmentIndexSpec});
            return true;
        }
        if (config.getGranularitySpec() != null) {
            ClientCompactionTaskGranularitySpec existingGranularitySpec;
            ClientCompactionTaskGranularitySpec clientCompactionTaskGranularitySpec = existingGranularitySpec = lastCompactionState.getGranularitySpec() != null ? (ClientCompactionTaskGranularitySpec)this.objectMapper.convertValue((Object)lastCompactionState.getGranularitySpec(), ClientCompactionTaskGranularitySpec.class) : null;
            if (config.getGranularitySpec().getSegmentGranularity() != null) {
                Granularity existingSegmentGranularity;
                Granularity granularity = existingSegmentGranularity = existingGranularitySpec != null ? existingGranularitySpec.getSegmentGranularity() : null;
                if (existingSegmentGranularity == null) {
                    boolean needsCompaction = candidates.segments.stream().anyMatch(segment -> !config.getGranularitySpec().getSegmentGranularity().isAligned(segment.getInterval()));
                    if (needsCompaction) {
                        log.info("Segments were previously compacted but without segmentGranularity in auto compaction. Configured segmentGranularity[%s] is different from granularity implied by segment intervals. Needs compaction", new Object[]{config.getGranularitySpec().getSegmentGranularity()});
                        return true;
                    }
                } else if (!config.getGranularitySpec().getSegmentGranularity().equals(existingSegmentGranularity)) {
                    log.info("Configured segmentGranularity[%s] is different from the segmentGranularity[%s] of segments. Needs compaction", new Object[]{config.getGranularitySpec().getSegmentGranularity(), existingSegmentGranularity});
                    return true;
                }
            }
            if (config.getGranularitySpec().isRollup() != null) {
                Boolean existingRollup;
                Boolean bl = existingRollup = existingGranularitySpec != null ? existingGranularitySpec.isRollup() : null;
                if (existingRollup == null || !config.getGranularitySpec().isRollup().equals(existingRollup)) {
                    log.info("Configured rollup[%s] is different from the rollup[%s] of segments. Needs compaction", new Object[]{config.getGranularitySpec().isRollup(), existingRollup});
                    return true;
                }
            }
            if (config.getGranularitySpec().getQueryGranularity() != null) {
                Granularity existingQueryGranularity;
                Granularity granularity = existingQueryGranularity = existingGranularitySpec != null ? existingGranularitySpec.getQueryGranularity() : null;
                if (!config.getGranularitySpec().getQueryGranularity().equals(existingQueryGranularity)) {
                    log.info("Configured queryGranularity[%s] is different from the queryGranularity[%s] of segments. Needs compaction", new Object[]{config.getGranularitySpec().getQueryGranularity(), existingQueryGranularity});
                    return true;
                }
            }
        }
        if (config.getDimensionsSpec() != null) {
            DimensionsSpec existingDimensionsSpec = lastCompactionState.getDimensionsSpec();
            if (config.getDimensionsSpec().getDimensions() != null) {
                List existingDimensions;
                List list = existingDimensions = existingDimensionsSpec != null ? existingDimensionsSpec.getDimensions() : null;
                if (!config.getDimensionsSpec().getDimensions().equals(existingDimensions)) {
                    log.info("Configured dimensionsSpec is different from the dimensionsSpec of segments. Needs compaction", new Object[0]);
                    return true;
                }
            }
        }
        if (config.getTransformSpec() != null) {
            ClientCompactionTaskTransformSpec existingTransformSpec;
            ClientCompactionTaskTransformSpec clientCompactionTaskTransformSpec = existingTransformSpec = lastCompactionState.getTransformSpec() != null ? (ClientCompactionTaskTransformSpec)this.objectMapper.convertValue((Object)lastCompactionState.getTransformSpec(), ClientCompactionTaskTransformSpec.class) : null;
            if (config.getTransformSpec().getFilter() != null) {
                DimFilter existingFilters;
                DimFilter dimFilter = existingFilters = existingTransformSpec != null ? existingTransformSpec.getFilter() : null;
                if (!config.getTransformSpec().getFilter().equals(existingFilters)) {
                    log.info("Configured filter[%s] is different from the filter[%s] of segments. Needs compaction", new Object[]{config.getTransformSpec().getFilter(), existingFilters});
                    return true;
                }
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])config.getMetricsSpec())) {
            Object[] existingMetricsSpec;
            Object[] objectArray = existingMetricsSpec = lastCompactionState.getMetricsSpec() == null || lastCompactionState.getMetricsSpec().isEmpty() ? null : (AggregatorFactory[])this.objectMapper.convertValue((Object)lastCompactionState.getMetricsSpec(), AggregatorFactory[].class);
            if (existingMetricsSpec == null || !Arrays.deepEquals(config.getMetricsSpec(), existingMetricsSpec)) {
                log.info("Configured metricsSpec[%s] is different from the metricsSpec[%s] of segments. Needs compaction", new Object[]{Arrays.toString(config.getMetricsSpec()), Arrays.toString(existingMetricsSpec)});
                return true;
            }
        }
        return false;
    }

    private SegmentsToCompact findSegmentsToCompact(String dataSourceName, CompactibleTimelineObjectHolderCursor compactibleTimelineObjectHolderCursor, DataSourceCompactionConfig config) {
        long inputSegmentSize = config.getInputSegmentSizeBytes();
        while (compactibleTimelineObjectHolderCursor.hasNext()) {
            Object segments = compactibleTimelineObjectHolderCursor.next();
            SegmentsToCompact candidates = new SegmentsToCompact((List)segments);
            if (!candidates.isEmpty()) {
                boolean isCompactibleSize = candidates.getTotalSize() <= inputSegmentSize;
                boolean needsCompaction = this.needsCompaction(config, candidates);
                if (isCompactibleSize && needsCompaction) {
                    if (config.getGranularitySpec() != null && config.getGranularitySpec().getSegmentGranularity() != null) {
                        Interval interval = candidates.getUmbrellaInterval();
                        Set intervalsCompacted = this.intervalCompactedForDatasource.computeIfAbsent(dataSourceName, k -> new HashSet());
                        if (intervalsCompacted.contains(interval)) continue;
                        intervalsCompacted.add(interval);
                    }
                    return candidates;
                }
                if (!needsCompaction) {
                    this.collectSegmentStatistics(this.compactedSegments, dataSourceName, candidates);
                    continue;
                }
                this.collectSegmentStatistics(this.skippedSegments, dataSourceName, candidates);
                log.warn("total segment size[%d] for datasource[%s] and interval[%s] is larger than inputSegmentSize[%d]. Continue to the next interval.", new Object[]{candidates.getTotalSize(), ((DataSegment)candidates.segments.get(0)).getDataSource(), ((DataSegment)candidates.segments.get(0)).getInterval(), inputSegmentSize});
                continue;
            }
            throw new ISE("No segment is found?", new Object[0]);
        }
        log.info("All segments look good! Nothing to compact", new Object[0]);
        return new SegmentsToCompact();
    }

    private void collectSegmentStatistics(Map<String, CompactionStatistics> statisticsMap, String dataSourceName, SegmentsToCompact segments) {
        CompactionStatistics statistics = statisticsMap.computeIfAbsent(dataSourceName, v -> CompactionStatistics.initializeCompactionStatistics());
        statistics.incrementCompactedByte(segments.getTotalSize());
        statistics.incrementCompactedIntervals(segments.getNumberOfIntervals());
        statistics.incrementCompactedSegments(segments.getNumberOfSegments());
    }

    private List<Interval> findInitialSearchInterval(String dataSourceName, VersionedIntervalTimeline<String, DataSegment> timeline, Period skipOffset, Granularity configuredSegmentGranularity, @Nullable List<Interval> skipIntervals) {
        Preconditions.checkArgument((timeline != null && !timeline.isEmpty() ? 1 : 0) != 0, (Object)"timeline should not be null or empty");
        Preconditions.checkNotNull((Object)skipOffset, (Object)"skipOffset");
        TimelineObjectHolder first = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.first(), (Object)"first");
        TimelineObjectHolder last = (TimelineObjectHolder)Preconditions.checkNotNull((Object)timeline.last(), (Object)"last");
        List<Interval> fullSkipIntervals = NewestSegmentFirstIterator.sortAndAddSkipIntervalFromLatest(last.getInterval().getEnd(), skipOffset, configuredSegmentGranularity, skipIntervals);
        for (Interval skipInterval : fullSkipIntervals) {
            ArrayList segments = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(skipInterval, Partitions.ONLY_COMPLETE));
            this.collectSegmentStatistics(this.skippedSegments, dataSourceName, new SegmentsToCompact(segments));
        }
        Interval totalInterval = new Interval((ReadableInstant)first.getInterval().getStart(), (ReadableInstant)last.getInterval().getEnd());
        List<Interval> filteredInterval = NewestSegmentFirstIterator.filterSkipIntervals(totalInterval, fullSkipIntervals);
        ArrayList<Interval> searchIntervals = new ArrayList<Interval>();
        for (Interval lookupInterval : filteredInterval) {
            List segments = timeline.findNonOvershadowedObjectsInInterval(lookupInterval, Partitions.ONLY_COMPLETE).stream().filter(segment -> lookupInterval.contains((ReadableInterval)segment.getInterval())).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            DateTime searchStart = segments.stream().map(segment -> segment.getId().getIntervalStart()).min(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            DateTime searchEnd = segments.stream().map(segment -> segment.getId().getIntervalEnd()).max(Comparator.naturalOrder()).orElseThrow(AssertionError::new);
            searchIntervals.add(new Interval((ReadableInstant)searchStart, (ReadableInstant)searchEnd));
        }
        return searchIntervals;
    }

    @VisibleForTesting
    static List<Interval> sortAndAddSkipIntervalFromLatest(DateTime latest, Period skipOffset, Granularity configuredSegmentGranularity, @Nullable List<Interval> skipIntervals) {
        Interval skipFromLatest;
        ArrayList<Interval> nonNullSkipIntervals;
        ArrayList<Object> arrayList = nonNullSkipIntervals = skipIntervals == null ? new ArrayList<Interval>(1) : new ArrayList(skipIntervals.size());
        if (configuredSegmentGranularity != null) {
            DateTime skipFromLastest = new DateTime((Object)latest, latest.getZone()).minus((ReadablePeriod)skipOffset);
            DateTime skipOffsetBucketToSegmentGranularity = configuredSegmentGranularity.bucketStart(skipFromLastest);
            skipFromLatest = new Interval((ReadableInstant)skipOffsetBucketToSegmentGranularity, (ReadableInstant)latest);
        } else {
            skipFromLatest = new Interval((ReadablePeriod)skipOffset, (ReadableInstant)latest);
        }
        if (skipIntervals != null) {
            ArrayList<Interval> sortedSkipIntervals = new ArrayList<Interval>(skipIntervals);
            sortedSkipIntervals.sort(Comparators.intervalsByStartThenEnd());
            ArrayList<Interval> overlapIntervals = new ArrayList<Interval>();
            for (Interval interval : sortedSkipIntervals) {
                if (interval.overlaps((ReadableInterval)skipFromLatest)) {
                    overlapIntervals.add(interval);
                    continue;
                }
                nonNullSkipIntervals.add(interval);
            }
            if (!overlapIntervals.isEmpty()) {
                overlapIntervals.add(skipFromLatest);
                nonNullSkipIntervals.add(JodaUtils.umbrellaInterval(overlapIntervals));
            } else {
                nonNullSkipIntervals.add(skipFromLatest);
            }
        } else {
            nonNullSkipIntervals.add(skipFromLatest);
        }
        return nonNullSkipIntervals;
    }

    @VisibleForTesting
    static List<Interval> filterSkipIntervals(Interval totalInterval, List<Interval> skipIntervals) {
        ArrayList<Interval> filteredIntervals = new ArrayList<Interval>(skipIntervals.size() + 1);
        DateTime remainingStart = totalInterval.getStart();
        DateTime remainingEnd = totalInterval.getEnd();
        for (Interval skipInterval : skipIntervals) {
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingStart) && skipInterval.getEnd().isAfter((ReadableInstant)remainingStart)) {
                remainingStart = skipInterval.getEnd();
                continue;
            }
            if (skipInterval.getStart().isBefore((ReadableInstant)remainingEnd) && skipInterval.getEnd().isAfter((ReadableInstant)remainingEnd)) {
                remainingEnd = skipInterval.getStart();
                continue;
            }
            if (!remainingStart.isAfter((ReadableInstant)skipInterval.getStart()) && !remainingEnd.isBefore((ReadableInstant)skipInterval.getEnd())) {
                filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)skipInterval.getStart()));
                remainingStart = skipInterval.getEnd();
                continue;
            }
            log.warn("skipInterval[%s] is not contained in remainingInterval[%s]", new Object[]{skipInterval, new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd)});
        }
        if (!remainingStart.equals((Object)remainingEnd)) {
            filteredIntervals.add(new Interval((ReadableInstant)remainingStart, (ReadableInstant)remainingEnd));
        }
        return filteredIntervals;
    }

    private static class SegmentsToCompact {
        private final List<DataSegment> segments;
        private final long totalSize;

        private SegmentsToCompact() {
            this(Collections.emptyList());
        }

        private SegmentsToCompact(List<DataSegment> segments) {
            this.segments = segments;
            this.totalSize = segments.stream().mapToLong(DataSegment::getSize).sum();
        }

        private boolean isEmpty() {
            return this.segments.isEmpty();
        }

        private long getTotalSize() {
            return this.totalSize;
        }

        private long getNumberOfSegments() {
            return this.segments.size();
        }

        private Interval getUmbrellaInterval() {
            return JodaUtils.umbrellaInterval((Iterable)this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        }

        private long getNumberOfIntervals() {
            return this.segments.stream().map(DataSegment::getInterval).distinct().count();
        }

        public String toString() {
            return "SegmentsToCompact{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", totalSize=" + this.totalSize + '}';
        }
    }

    private static class QueueEntry {
        private final Interval interval;
        private final List<DataSegment> segments;

        private QueueEntry(List<DataSegment> segments) {
            Preconditions.checkArgument((segments != null && !segments.isEmpty() ? 1 : 0) != 0);
            DateTime minStart = DateTimes.MAX;
            DateTime maxEnd = DateTimes.MIN;
            for (DataSegment segment : segments) {
                if (segment.getInterval().getStart().compareTo((ReadableInstant)minStart) < 0) {
                    minStart = segment.getInterval().getStart();
                }
                if (segment.getInterval().getEnd().compareTo((ReadableInstant)maxEnd) <= 0) continue;
                maxEnd = segment.getInterval().getEnd();
            }
            this.interval = new Interval((ReadableInstant)minStart, (ReadableInstant)maxEnd);
            this.segments = segments;
        }

        private String getDataSource() {
            return this.segments.get(0).getDataSource();
        }
    }

    private static class CompactibleTimelineObjectHolderCursor
    implements Iterator<List<DataSegment>> {
        private final List<TimelineObjectHolder<String, DataSegment>> holders;
        @Nullable
        private final VersionedIntervalTimeline<String, DataSegment> originalTimeline;

        CompactibleTimelineObjectHolderCursor(VersionedIntervalTimeline<String, DataSegment> timeline, List<Interval> totalIntervalsToSearch, @Nullable VersionedIntervalTimeline<String, DataSegment> originalTimeline) {
            this.holders = totalIntervalsToSearch.stream().flatMap(interval -> timeline.lookup(interval).stream().filter(holder -> this.isCompactibleHolder((Interval)interval, (TimelineObjectHolder<String, DataSegment>)holder))).collect(Collectors.toList());
            this.originalTimeline = originalTimeline;
        }

        private boolean isCompactibleHolder(Interval interval, TimelineObjectHolder<String, DataSegment> holder) {
            long partitionBytes;
            Iterator chunks = holder.getObject().iterator();
            if (!chunks.hasNext()) {
                return false;
            }
            PartitionChunk firstChunk = (PartitionChunk)chunks.next();
            if (!interval.contains((ReadableInterval)((DataSegment)firstChunk.getObject()).getInterval())) {
                return false;
            }
            for (partitionBytes = ((DataSegment)firstChunk.getObject()).getSize(); partitionBytes == 0L && chunks.hasNext(); partitionBytes += ((DataSegment)((PartitionChunk)chunks.next()).getObject()).getSize()) {
            }
            return partitionBytes > 0L;
        }

        @Override
        public boolean hasNext() {
            return !this.holders.isEmpty();
        }

        @Override
        public List<DataSegment> next() {
            if (this.holders.isEmpty()) {
                throw new NoSuchElementException();
            }
            TimelineObjectHolder<String, DataSegment> timelineObjectHolder = this.holders.remove(this.holders.size() - 1);
            List<DataSegment> candidates = Streams.sequentialStreamFrom((Iterable)timelineObjectHolder.getObject()).map(PartitionChunk::getObject).collect(Collectors.toList());
            if (this.originalTimeline != null) {
                Interval umbrellaInterval = JodaUtils.umbrellaInterval((Iterable)candidates.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
                return Lists.newArrayList((Iterable)this.originalTimeline.findNonOvershadowedObjectsInInterval(umbrellaInterval, Partitions.ONLY_COMPLETE));
            }
            return candidates;
        }
    }
}

