/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;

public class KillDatasourceMetadata
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillDatasourceMetadata.class);
    private final long period;
    private final long retainDuration;
    private long lastKillTime = 0L;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final MetadataSupervisorManager metadataSupervisorManager;

    @Inject
    public KillDatasourceMetadata(DruidCoordinatorConfig config, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, MetadataSupervisorManager metadataSupervisorManager) {
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.period = config.getCoordinatorDatasourceKillPeriod().getMillis();
        Preconditions.checkArgument((this.period >= config.getCoordinatorMetadataStoreManagementPeriod().getMillis() ? 1 : 0) != 0, (Object)"Coordinator datasource metadata kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.retainDuration = config.getCoordinatorDatasourceKillDurationToRetain().getMillis();
        Preconditions.checkArgument((this.retainDuration >= 0L ? 1 : 0) != 0, (Object)"Coordinator datasource metadata kill retainDuration must be >= 0");
        Preconditions.checkArgument((this.retainDuration < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Coordinator datasource metadata kill retainDuration cannot be greater than current time in ms");
        log.debug("Datasource Metadata Kill Task scheduling enabled with period [%s], retainDuration [%s]", new Object[]{this.period, this.retainDuration});
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastKillTime + this.period < currentTimeMillis) {
            this.lastKillTime = currentTimeMillis;
            long timestamp = currentTimeMillis - this.retainDuration;
            try {
                Map<String, SupervisorSpec> allActiveSupervisor = this.metadataSupervisorManager.getLatestActiveOnly();
                Set<String> allDatasourceWithActiveSupervisor = allActiveSupervisor.values().stream().map(supervisorSpec -> supervisorSpec.getDataSources()).flatMap(Collection::stream).filter(datasource -> !Strings.isNullOrEmpty((String)datasource)).collect(Collectors.toSet());
                int datasourceMetadataRemovedCount = this.indexerMetadataStorageCoordinator.removeDataSourceMetadataOlderThan(timestamp, allDatasourceWithActiveSupervisor);
                ServiceEmitter emitter = params.getEmitter();
                emitter.emit(new ServiceMetricEvent.Builder().build("metadata/kill/datasource/count", (Number)datasourceMetadataRemovedCount));
                log.info("Finished running KillDatasourceMetadata duty. Removed %,d datasource metadata", new Object[]{datasourceMetadataRemovedCount});
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to kill datasource metadata", new Object[0]);
            }
        }
        return params;
    }
}

