/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.timeline.SegmentId;

public class ReplicationThrottler {
    private static final EmittingLogger log = new EmittingLogger(ReplicationThrottler.class);
    private final Map<String, Boolean> replicatingLookup = new HashMap<String, Boolean>();
    private final ReplicatorSegmentHolder currentlyReplicating = new ReplicatorSegmentHolder();
    private volatile int maxReplicants;
    private volatile int maxLifetime;
    private volatile boolean loadPrimaryReplicantsOnly;

    public ReplicationThrottler(int maxReplicants, int maxLifetime, boolean loadPrimaryReplicantsOnly) {
        this.updateParams(maxReplicants, maxLifetime, loadPrimaryReplicantsOnly);
    }

    public void updateParams(int maxReplicants, int maxLifetime, boolean loadPrimaryReplicantsOnly) {
        this.maxReplicants = maxReplicants;
        this.maxLifetime = maxLifetime;
        this.loadPrimaryReplicantsOnly = loadPrimaryReplicantsOnly;
    }

    public void updateReplicationState(String tier) {
        this.update(tier, this.currentlyReplicating, this.replicatingLookup, "create");
    }

    public boolean isLoadPrimaryReplicantsOnly() {
        return this.loadPrimaryReplicantsOnly;
    }

    public void setLoadPrimaryReplicantsOnly(boolean loadPrimaryReplicantsOnly) {
        this.loadPrimaryReplicantsOnly = loadPrimaryReplicantsOnly;
    }

    private void update(String tier, ReplicatorSegmentHolder holder, Map<String, Boolean> lookup, String type) {
        int size = holder.getNumProcessing(tier);
        if (size != 0) {
            log.info("[%s]: Replicant %s queue still has %d segments. Lifetime[%d]. Segments %s", new Object[]{tier, type, size, holder.getLifetime(tier), holder.getCurrentlyProcessingSegmentsAndHosts(tier)});
            holder.reduceLifetime(tier);
            lookup.put(tier, false);
            if (holder.getLifetime(tier) < 0) {
                log.makeAlert("[%s]: Replicant %s queue stuck after %d+ runs!", new Object[]{tier, type, this.maxLifetime}).addData("segments", holder.getCurrentlyProcessingSegmentsAndHosts(tier)).emit();
            }
        } else {
            log.info("[%s]: Replicant %s queue is empty.", new Object[]{tier, type});
            lookup.put(tier, true);
            holder.resetLifetime(tier);
        }
    }

    public boolean canCreateReplicant(String tier) {
        return !this.loadPrimaryReplicantsOnly && this.replicatingLookup.get(tier) != false && !this.currentlyReplicating.isAtMaxReplicants(tier);
    }

    public void registerReplicantCreation(String tier, SegmentId segmentId, String serverId) {
        this.currentlyReplicating.addSegment(tier, segmentId, serverId);
    }

    public void unregisterReplicantCreation(String tier, SegmentId segmentId) {
        this.currentlyReplicating.removeSegment(tier, segmentId);
    }

    private class ReplicatorSegmentHolder {
        private final Map<String, ConcurrentHashMap<SegmentId, String>> currentlyProcessingSegments = new HashMap<String, ConcurrentHashMap<SegmentId, String>>();
        private final Map<String, Integer> lifetimes = new HashMap<String, Integer>();

        private ReplicatorSegmentHolder() {
        }

        public boolean isAtMaxReplicants(String tier) {
            ConcurrentHashMap<SegmentId, String> segments = this.currentlyProcessingSegments.get(tier);
            return segments != null && segments.size() >= ReplicationThrottler.this.maxReplicants;
        }

        public void addSegment(String tier, SegmentId segmentId, String serverId) {
            ConcurrentHashMap segments = this.currentlyProcessingSegments.computeIfAbsent(tier, t -> new ConcurrentHashMap());
            if (!this.isAtMaxReplicants(tier)) {
                segments.put(segmentId, serverId);
            }
        }

        public void removeSegment(String tier, SegmentId segmentId) {
            ConcurrentMap segments = this.currentlyProcessingSegments.get(tier);
            if (segments != null) {
                segments.remove(segmentId);
            }
        }

        public int getNumProcessing(String tier) {
            ConcurrentMap segments = this.currentlyProcessingSegments.get(tier);
            return segments == null ? 0 : segments.size();
        }

        public int getLifetime(String tier) {
            Integer lifetime = this.lifetimes.putIfAbsent(tier, ReplicationThrottler.this.maxLifetime);
            return lifetime != null ? lifetime : ReplicationThrottler.this.maxLifetime;
        }

        public void reduceLifetime(String tier) {
            this.lifetimes.compute(tier, (t, lifetime) -> {
                if (lifetime == null) {
                    return ReplicationThrottler.this.maxLifetime - 1;
                }
                return lifetime - 1;
            });
        }

        public void resetLifetime(String tier) {
            this.lifetimes.put(tier, ReplicationThrottler.this.maxLifetime);
        }

        public List<String> getCurrentlyProcessingSegmentsAndHosts(String tier) {
            ConcurrentMap segments = this.currentlyProcessingSegments.get(tier);
            ArrayList<String> segmentsAndHosts = new ArrayList<String>();
            segments.forEach((segmentId, serverId) -> segmentsAndHosts.add(segmentId + " ON " + serverId));
            return segmentsAndHosts;
        }
    }
}

