/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class CoordinatorCompactionConfig {
    public static final String CONFIG_KEY = "coordinator.compaction.config";
    private static final double DEFAULT_COMPACTION_TASK_RATIO = 0.1;
    private static final int DEFAILT_MAX_COMPACTION_TASK_SLOTS = Integer.MAX_VALUE;
    private static final boolean DEFAULT_USE_AUTO_SCALE_SLOTS = false;
    private final List<DataSourceCompactionConfig> compactionConfigs;
    private final double compactionTaskSlotRatio;
    private final int maxCompactionTaskSlots;
    private final boolean useAutoScaleSlots;

    public static CoordinatorCompactionConfig from(CoordinatorCompactionConfig baseConfig, List<DataSourceCompactionConfig> compactionConfigs) {
        return new CoordinatorCompactionConfig(compactionConfigs, baseConfig.compactionTaskSlotRatio, baseConfig.maxCompactionTaskSlots, baseConfig.useAutoScaleSlots);
    }

    public static CoordinatorCompactionConfig from(CoordinatorCompactionConfig baseConfig, @Nullable Double compactionTaskSlotRatio, @Nullable Integer maxCompactionTaskSlots, @Nullable Boolean useAutoScaleSlots) {
        return new CoordinatorCompactionConfig(baseConfig.compactionConfigs, compactionTaskSlotRatio == null ? baseConfig.compactionTaskSlotRatio : compactionTaskSlotRatio, maxCompactionTaskSlots == null ? baseConfig.maxCompactionTaskSlots : maxCompactionTaskSlots, useAutoScaleSlots == null ? baseConfig.useAutoScaleSlots : useAutoScaleSlots);
    }

    public static CoordinatorCompactionConfig from(List<DataSourceCompactionConfig> compactionConfigs) {
        return new CoordinatorCompactionConfig(compactionConfigs, null, null, null);
    }

    public static CoordinatorCompactionConfig empty() {
        return new CoordinatorCompactionConfig((List<DataSourceCompactionConfig>)ImmutableList.of(), null, null, null);
    }

    public static AtomicReference<CoordinatorCompactionConfig> watch(JacksonConfigManager configManager) {
        return configManager.watch(CONFIG_KEY, CoordinatorCompactionConfig.class, (Object)CoordinatorCompactionConfig.empty());
    }

    public static byte[] getConfigInByteFromDb(MetadataStorageConnector connector, MetadataStorageTablesConfig config) {
        return connector.lookup(config.getConfigTable(), "name", "payload", CONFIG_KEY);
    }

    public static CoordinatorCompactionConfig convertByteToConfig(JacksonConfigManager configManager, byte[] configInByte) {
        return (CoordinatorCompactionConfig)configManager.convertByteToConfig(configInByte, CoordinatorCompactionConfig.class, (Object)CoordinatorCompactionConfig.empty());
    }

    @Nonnull
    public static CoordinatorCompactionConfig current(JacksonConfigManager configManager) {
        return (CoordinatorCompactionConfig)Preconditions.checkNotNull((Object)CoordinatorCompactionConfig.watch(configManager).get(), (Object)"Got null config from watcher?!");
    }

    @JsonCreator
    public CoordinatorCompactionConfig(@JsonProperty(value="compactionConfigs") List<DataSourceCompactionConfig> compactionConfigs, @JsonProperty(value="compactionTaskSlotRatio") @Nullable Double compactionTaskSlotRatio, @JsonProperty(value="maxCompactionTaskSlots") @Nullable Integer maxCompactionTaskSlots, @JsonProperty(value="useAutoScaleSlots") @Nullable Boolean useAutoScaleSlots) {
        this.compactionConfigs = compactionConfigs;
        this.compactionTaskSlotRatio = compactionTaskSlotRatio == null ? 0.1 : compactionTaskSlotRatio;
        this.maxCompactionTaskSlots = maxCompactionTaskSlots == null ? Integer.MAX_VALUE : maxCompactionTaskSlots;
        this.useAutoScaleSlots = useAutoScaleSlots == null ? false : useAutoScaleSlots;
    }

    @JsonProperty
    public List<DataSourceCompactionConfig> getCompactionConfigs() {
        return this.compactionConfigs;
    }

    @JsonProperty
    public double getCompactionTaskSlotRatio() {
        return this.compactionTaskSlotRatio;
    }

    @JsonProperty
    public int getMaxCompactionTaskSlots() {
        return this.maxCompactionTaskSlots;
    }

    @JsonProperty
    public boolean isUseAutoScaleSlots() {
        return this.useAutoScaleSlots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorCompactionConfig that = (CoordinatorCompactionConfig)o;
        return Double.compare(that.compactionTaskSlotRatio, this.compactionTaskSlotRatio) == 0 && this.maxCompactionTaskSlots == that.maxCompactionTaskSlots && this.useAutoScaleSlots == that.useAutoScaleSlots && Objects.equals(this.compactionConfigs, that.compactionConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.compactionConfigs, this.compactionTaskSlotRatio, this.maxCompactionTaskSlots, this.useAutoScaleSlots);
    }

    public String toString() {
        return "CoordinatorCompactionConfig{compactionConfigs=" + this.compactionConfigs + ", compactionTaskSlotRatio=" + this.compactionTaskSlotRatio + ", maxCompactionTaskSlots=" + this.maxCompactionTaskSlots + ", useAutoScaleSlots=" + this.useAutoScaleSlots + '}';
    }
}

