/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.druid.java.util.common.StringUtils;

public enum ServerType {
    HISTORICAL{

        @Override
        public boolean isSegmentReplicationTarget() {
            return true;
        }

        @Override
        public boolean isSegmentServer() {
            return true;
        }
    }
    ,
    BRIDGE{

        @Override
        public boolean isSegmentReplicationTarget() {
            return true;
        }

        @Override
        public boolean isSegmentServer() {
            return true;
        }
    }
    ,
    INDEXER_EXECUTOR{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }

        @Override
        public boolean isSegmentServer() {
            return true;
        }
    }
    ,
    REALTIME{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }

        @Override
        public boolean isSegmentServer() {
            return true;
        }
    }
    ,
    BROKER{

        @Override
        public boolean isSegmentReplicationTarget() {
            return false;
        }

        @Override
        public boolean isSegmentServer() {
            return false;
        }
    };


    public abstract boolean isSegmentReplicationTarget();

    public boolean isSegmentBroadcastTarget() {
        return true;
    }

    public abstract boolean isSegmentServer();

    @JsonCreator
    public static ServerType fromString(String type) {
        return ServerType.valueOf(StringUtils.toUpperCase((String)type).replace('-', '_'));
    }

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase((String)this.name()).replace('_', '-');
    }
}

