/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.joda.time.Interval;

public class MapSegmentWrangler
implements SegmentWrangler {
    private final Map<Class<? extends DataSource>, SegmentWrangler> wranglers;

    @Inject
    public MapSegmentWrangler(Map<Class<? extends DataSource>, SegmentWrangler> wranglers) {
        this.wranglers = wranglers;
    }

    public Iterable<Segment> getSegmentsForIntervals(DataSource dataSource, Iterable<Interval> intervals) {
        SegmentWrangler wrangler = this.wranglers.get(dataSource.getClass());
        if (wrangler != null) {
            return wrangler.getSegmentsForIntervals(dataSource, intervals);
        }
        throw new ISE("Cannot read directly out of dataSource: %s", new Object[]{dataSource});
    }
}

