/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.indexing;

import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class SpecificTaskRetryPolicy
implements ServiceRetryPolicy {
    private final String taskId;
    private final ServiceRetryPolicy baseRetryPolicy;

    public SpecificTaskRetryPolicy(String taskId, ServiceRetryPolicy baseRetryPolicy) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.baseRetryPolicy = (ServiceRetryPolicy)Preconditions.checkNotNull((Object)baseRetryPolicy, (Object)"baseRetryPolicy");
    }

    @Override
    public long maxAttempts() {
        return this.baseRetryPolicy.maxAttempts();
    }

    @Override
    public long minWaitMillis() {
        return this.baseRetryPolicy.minWaitMillis();
    }

    @Override
    public long maxWaitMillis() {
        return this.baseRetryPolicy.maxWaitMillis();
    }

    @Override
    public boolean retryHttpResponse(HttpResponse response) {
        return this.baseRetryPolicy.retryHttpResponse(response) || this.isTaskMismatch(response);
    }

    @Override
    public boolean retryThrowable(Throwable t) {
        return StandardRetryPolicy.unlimited().retryThrowable(t);
    }

    private boolean isTaskMismatch(HttpResponse response) {
        if (response.getStatus().equals((Object)HttpResponseStatus.NOT_FOUND) || response.getStatus().equals((Object)HttpResponseStatus.BAD_REQUEST)) {
            String headerTaskId = StringUtils.urlDecode((String)response.headers().get("X-Druid-Task-Id"));
            return headerTaskId != null && !headerTaskId.equals(this.taskId);
        }
        return false;
    }
}

