/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.rpc.DiscoveryServiceLocator;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceClientFactoryImpl;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.OverlordClientImpl;

public class ServiceClientModule
implements DruidModule {
    private static final int CONNECT_EXEC_THREADS = 4;
    private static final int OVERLORD_ATTEMPTS = 6;

    public void configure(Binder binder) {
    }

    @Provides
    @LazySingleton
    @EscalatedGlobal
    public ServiceClientFactory makeServiceClientFactory(@EscalatedGlobal HttpClient httpClient) {
        ScheduledExecutorService connectExec = ScheduledExecutors.fixed((int)4, (String)"ServiceClientFactory-%d");
        return new ServiceClientFactoryImpl(httpClient, connectExec);
    }

    @Provides
    @ManageLifecycle
    @IndexingService
    public ServiceLocator makeOverlordServiceLocator(DruidNodeDiscoveryProvider discoveryProvider) {
        return new DiscoveryServiceLocator(discoveryProvider, NodeRole.OVERLORD);
    }

    @Provides
    public OverlordClient makeOverlordClient(@Json ObjectMapper jsonMapper, @EscalatedGlobal ServiceClientFactory clientFactory, @IndexingService ServiceLocator serviceLocator) {
        return new OverlordClientImpl(clientFactory.makeClient(NodeRole.OVERLORD.getJsonName(), serviceLocator, StandardRetryPolicy.builder().maxAttempts(6L).build()), jsonMapper);
    }
}

