/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.rpc.ServiceLocation;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;

public class RequestBuilder {
    @VisibleForTesting
    static final Duration DEFAULT_TIMEOUT = Duration.standardMinutes((long)2L);
    private final HttpMethod method;
    private final String encodedPathAndQueryString;
    private final Multimap<String, String> headers = HashMultimap.create();
    private String contentType = null;
    private byte[] content = null;
    private Duration timeout = DEFAULT_TIMEOUT;

    public RequestBuilder(HttpMethod method, String encodedPathAndQueryString) {
        this.method = (HttpMethod)Preconditions.checkNotNull((Object)method, (Object)"method");
        this.encodedPathAndQueryString = (String)Preconditions.checkNotNull((Object)encodedPathAndQueryString, (Object)"encodedPathAndQueryString");
        if (!encodedPathAndQueryString.startsWith("/")) {
            throw new IAE("Path must start with '/'", new Object[0]);
        }
    }

    public RequestBuilder header(String header, String value) {
        this.headers.put((Object)header, (Object)value);
        return this;
    }

    public RequestBuilder content(String contentType, byte[] content) {
        this.contentType = (String)Preconditions.checkNotNull((Object)contentType, (Object)"contentType");
        this.content = (byte[])Preconditions.checkNotNull((Object)content, (Object)"content");
        return this;
    }

    public RequestBuilder jsonContent(ObjectMapper jsonMapper, Object content) {
        try {
            this.contentType = "application/json";
            this.content = jsonMapper.writeValueAsBytes(Preconditions.checkNotNull((Object)content, (Object)"content"));
            return this;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestBuilder smileContent(ObjectMapper smileMapper, Object content) {
        try {
            this.contentType = "application/x-jackson-smile";
            this.content = smileMapper.writeValueAsBytes(Preconditions.checkNotNull((Object)content, (Object)"content"));
            return this;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestBuilder timeout(Duration timeout) {
        this.timeout = (Duration)Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Request build(ServiceLocation serviceLocation) {
        String path = serviceLocation.getBasePath() + this.encodedPathAndQueryString;
        Request request = new Request(this.method, this.makeURL(serviceLocation, path));
        for (Map.Entry entry : this.headers.entries()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.contentType != null) {
            request.setContent(this.contentType, this.content);
        }
        return request;
    }

    private URL makeURL(ServiceLocation serviceLocation, String encodedPathAndQueryString) {
        int portToUse;
        String scheme;
        if (serviceLocation.getTlsPort() > 0) {
            scheme = "https";
            portToUse = serviceLocation.getTlsPort();
        } else {
            scheme = "http";
            portToUse = serviceLocation.getPlaintextPort();
        }
        try {
            return new URL(scheme, serviceLocation.getHost(), portToUse, encodedPathAndQueryString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestBuilder that = (RequestBuilder)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.encodedPathAndQueryString, that.encodedPathAndQueryString) && Objects.equals(this.headers, that.headers) && Objects.equals(this.contentType, that.contentType) && Arrays.equals(this.content, that.content) && Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        int result = Objects.hash(this.method, this.encodedPathAndQueryString, this.headers, this.contentType, this.timeout);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

