/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.SQLMetadataStorageActionHandler;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.exceptions.ResultSetException;

public class SqlEntity
implements InputEntity {
    private static final Logger LOG = new Logger(SqlEntity.class);
    private final String sql;
    private final ObjectMapper objectMapper;
    private final SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector;
    private final boolean foldCase;

    public SqlEntity(String sql, SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, boolean foldCase, ObjectMapper objectMapper) {
        this.sql = sql;
        this.sqlFirehoseDatabaseConnector = (SQLFirehoseDatabaseConnector)Preconditions.checkNotNull((Object)sqlFirehoseDatabaseConnector, (Object)"SQL Metadata Connector not configured!");
        this.foldCase = foldCase;
        this.objectMapper = objectMapper;
    }

    public String getSql() {
        return this.sql;
    }

    @Nullable
    public URI getUri() {
        return null;
    }

    public InputStream open() {
        throw new UnsupportedOperationException("Please use fetch() instead");
    }

    public InputEntity.CleanableFile fetch(File temporaryDirectory, byte[] fetchBuffer) throws IOException {
        File tempFile = File.createTempFile("druid-sql-entity", ".tmp", temporaryDirectory);
        return SqlEntity.openCleanableFile(this.sql, this.sqlFirehoseDatabaseConnector, this.objectMapper, this.foldCase, tempFile);
    }

    /*
     * Exception decompiling
     */
    public static InputEntity.CleanableFile openCleanableFile(String sql, SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, ObjectMapper objectMapper, boolean foldCase, File tempFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$openCleanableFile$2(SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, Throwable exception) {
        return sqlFirehoseDatabaseConnector.isTransientException(exception) && !SQLMetadataStorageActionHandler.isStatementException(exception);
    }

    private static /* synthetic */ Object lambda$openCleanableFile$1(String sql, boolean foldCase, JsonGenerator jg, SerializerProvider serializers, Handle handle) throws Exception {
        ResultIterator resultIterator = handle.createQuery(sql).map((index, r, ctx) -> {
            ResultSetMetaData resultMetadata;
            HashMap resultRow = foldCase ? new CaseFoldedMap() : new HashMap();
            try {
                resultMetadata = r.getMetaData();
            }
            catch (SQLException e) {
                throw new ResultSetException("Unable to obtain metadata from result set", (Exception)e, ctx);
            }
            try {
                for (int i = 1; i <= resultMetadata.getColumnCount(); ++i) {
                    String key = resultMetadata.getColumnName(i);
                    String alias = resultMetadata.getColumnLabel(i);
                    Object value = r.getObject(i);
                    resultRow.put(alias != null ? alias : key, value);
                }
            }
            catch (SQLException e) {
                throw new ResultSetException("Unable to access specific metadata from result set metadata", (Exception)e, ctx);
            }
            return resultRow;
        }).iterator();
        jg.writeStartArray();
        while (resultIterator.hasNext()) {
            JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)jg, (SerializerProvider)serializers, (Object)resultIterator.next());
        }
        jg.writeEndArray();
        jg.close();
        return null;
    }

    private static class CaseFoldedMap
    extends HashMap<String, Object> {
        public static final long serialVersionUID = 1L;

        private CaseFoldedMap() {
        }

        @Override
        public Object get(Object obj) {
            return super.get(obj == null ? null : StringUtils.toLowerCase((String)((String)obj)));
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key == null ? null : StringUtils.toLowerCase((String)key), value);
        }

        @Override
        public boolean containsKey(Object obj) {
            return super.containsKey(obj == null ? null : StringUtils.toLowerCase((String)((String)obj)));
        }
    }
}

