/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.Min;
import org.apache.druid.query.Query;

public class CacheConfig {
    public static final String POPULATE_CACHE = "populateCache";
    @JsonProperty
    private boolean useCache = false;
    @JsonProperty
    private boolean populateCache = false;
    @JsonProperty
    private boolean useResultLevelCache = false;
    @JsonProperty
    private boolean populateResultLevelCache = false;
    @JsonProperty
    @Min(value=0L)
    private int numBackgroundThreads = 0;
    @JsonProperty
    @Min(value=0L)
    private int cacheBulkMergeLimit = Integer.MAX_VALUE;
    @JsonProperty
    private int maxEntrySize = 1000000;
    @JsonProperty
    private List<String> unCacheable = ImmutableList.of();
    @JsonProperty
    private int resultLevelCacheLimit = Integer.MAX_VALUE;

    public boolean isPopulateCache() {
        return this.populateCache;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isPopulateResultLevelCache() {
        return this.populateResultLevelCache;
    }

    public boolean isUseResultLevelCache() {
        return this.useResultLevelCache;
    }

    public int getNumBackgroundThreads() {
        return this.numBackgroundThreads;
    }

    public int getCacheBulkMergeLimit() {
        return this.cacheBulkMergeLimit;
    }

    public int getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public int getResultLevelCacheLimit() {
        return this.resultLevelCacheLimit;
    }

    public boolean isQueryCacheable(Query query) {
        return this.isQueryCacheable(query.getType());
    }

    public boolean isQueryCacheable(String queryType) {
        return !this.unCacheable.contains(queryType);
    }
}

