/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import java.util.Map;
import org.apache.druid.indexing.worker.shuffle.ShuffleMetrics;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ShuffleMonitor
extends AbstractMonitor {
    static final String SUPERVISOR_TASK_ID_DIMENSION = "supervisorTaskId";
    static final String SHUFFLE_BYTES_KEY = "ingest/shuffle/bytes";
    static final String SHUFFLE_REQUESTS_KEY = "ingest/shuffle/requests";
    private @MonotonicNonNull ShuffleMetrics shuffleMetrics;

    public void setShuffleMetrics(ShuffleMetrics shuffleMetrics) {
        this.shuffleMetrics = shuffleMetrics;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.shuffleMetrics != null) {
            Map<String, ShuffleMetrics.PerDatasourceShuffleMetrics> snapshot = this.shuffleMetrics.snapshotAndReset();
            snapshot.forEach((supervisorTaskId, perDatasourceShuffleMetrics) -> {
                ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder().setDimension(SUPERVISOR_TASK_ID_DIMENSION, supervisorTaskId);
                emitter.emit(metricBuilder.build(SHUFFLE_BYTES_KEY, (Number)perDatasourceShuffleMetrics.getShuffleBytes()));
                emitter.emit(metricBuilder.build(SHUFFLE_REQUESTS_KEY, (Number)perDatasourceShuffleMetrics.getShuffleRequests()));
            });
        }
        return true;
    }
}

