/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker.shuffle;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ShuffleMetrics {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Map<String, PerDatasourceShuffleMetrics> datasourceMetrics = new HashMap<String, PerDatasourceShuffleMetrics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuffleRequested(String supervisorTaskId, long fileLength) {
        Object object = this.lock;
        synchronized (object) {
            this.datasourceMetrics.computeIfAbsent(supervisorTaskId, k -> new PerDatasourceShuffleMetrics()).accumulate(fileLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PerDatasourceShuffleMetrics> snapshotAndReset() {
        Object object = this.lock;
        synchronized (object) {
            Map<String, PerDatasourceShuffleMetrics> snapshot = Collections.unmodifiableMap(this.datasourceMetrics);
            this.datasourceMetrics = new HashMap<String, PerDatasourceShuffleMetrics>();
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<String, PerDatasourceShuffleMetrics> getDatasourceMetrics() {
        Object object = this.lock;
        synchronized (object) {
            return this.datasourceMetrics;
        }
    }

    public static class PerDatasourceShuffleMetrics {
        private long shuffleBytes;
        private int shuffleRequests;

        @VisibleForTesting
        void accumulate(long shuffleBytes) {
            this.shuffleBytes += shuffleBytes;
            ++this.shuffleRequests;
        }

        public long getShuffleBytes() {
            return this.shuffleBytes;
        }

        public int getShuffleRequests() {
            return this.shuffleRequests;
        }
    }
}

