/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Optional;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IndexerMetadataStorageAdapter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;

    @Inject
    public IndexerMetadataStorageAdapter(TaskStorageQueryAdapter taskStorageQueryAdapter, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator) {
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
    }

    public int deletePendingSegments(String dataSource, Interval deleteInterval) {
        Optional<DateTime> minCreatedDateOfActiveTasks = this.taskStorageQueryAdapter.getActiveTaskInfo(dataSource).stream().map(TaskInfo::getCreatedTime).min(Comparator.naturalOrder());
        Interval activeTaskInterval = new Interval((ReadableInstant)minCreatedDateOfActiveTasks.orElse(DateTimes.MAX), (ReadableInstant)DateTimes.MAX);
        Preconditions.checkArgument((!deleteInterval.overlaps((ReadableInterval)activeTaskInterval) ? 1 : 0) != 0, (String)"Cannot delete pendingSegments because there is at least one active task created at %s", (Object[])new Object[]{activeTaskInterval.getStart()});
        return this.indexerMetadataStorageCoordinator.deletePendingSegmentsCreatedInInterval(dataSource, deleteInterval);
    }
}

