/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Properties;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.overlord.ForkingTaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.tasklogs.TaskLogPusher;

public class ForkingTaskRunnerFactory
implements TaskRunnerFactory<ForkingTaskRunner> {
    private final ForkingTaskRunnerConfig config;
    private final TaskConfig taskConfig;
    private final WorkerConfig workerConfig;
    private final Properties props;
    private final ObjectMapper jsonMapper;
    private final TaskLogPusher persistentTaskLogs;
    private final DruidNode node;
    private final StartupLoggingConfig startupLoggingConfig;

    @Inject
    public ForkingTaskRunnerFactory(ForkingTaskRunnerConfig config, TaskConfig taskConfig, WorkerConfig workerConfig, Properties props, ObjectMapper jsonMapper, TaskLogPusher persistentTaskLogs, @Self DruidNode node, StartupLoggingConfig startupLoggingConfig) {
        this.config = config;
        this.taskConfig = taskConfig;
        this.workerConfig = workerConfig;
        this.props = props;
        this.jsonMapper = jsonMapper;
        this.persistentTaskLogs = persistentTaskLogs;
        this.node = node;
        this.startupLoggingConfig = startupLoggingConfig;
    }

    @Override
    public ForkingTaskRunner build() {
        return new ForkingTaskRunner(this.config, this.taskConfig, this.workerConfig, this.props, this.persistentTaskLogs, this.jsonMapper, this.node, this.startupLoggingConfig);
    }
}

