/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.druid.utils.CloseableUtils;
import org.apache.druid.utils.CollectionUtils;

public class DruidSegmentReader
extends IntermediateRowParsingReader<Map<String, Object>> {
    private DruidSegmentInputEntity source;
    private final IndexIO indexIO;
    private final ColumnsFilter columnsFilter;
    private final InputRowSchema inputRowSchema;
    private final DimFilter dimFilter;
    private final File temporaryDirectory;

    DruidSegmentReader(InputEntity source, IndexIO indexIO, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, ColumnsFilter columnsFilter, DimFilter dimFilter, File temporaryDirectory) {
        this.source = (DruidSegmentInputEntity)source;
        this.indexIO = indexIO;
        this.columnsFilter = columnsFilter;
        this.inputRowSchema = new InputRowSchema(timestampSpec, dimensionsSpec, columnsFilter);
        this.dimFilter = dimFilter;
        this.temporaryDirectory = temporaryDirectory;
    }

    protected CloseableIterator<Map<String, Object>> intermediateRowIterator() throws IOException {
        InputEntity.CleanableFile segmentFile = this.source().fetch(this.temporaryDirectory, null);
        WindowedStorageAdapter storageAdapter = new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(this.indexIO.loadIndex(segmentFile.file())), this.source.getIntervalFilter());
        Sequence cursors = storageAdapter.getAdapter().makeCursors(Filters.toFilter((DimFilter)this.dimFilter), storageAdapter.getInterval(), VirtualColumns.EMPTY, Granularities.ALL, false, null);
        LinkedHashSet columnsToRead = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)storageAdapter.getAdapter().getRowSignature().getColumnNames(), arg_0 -> ((ColumnsFilter)this.columnsFilter).apply(arg_0)));
        Sequence sequence = Sequences.concat((Sequence)Sequences.map((Sequence)cursors, cursor -> this.cursorToSequence((Cursor)cursor, columnsToRead)));
        return DruidSegmentReader.makeCloseableIteratorFromSequenceAndSegmentFile((Sequence<Map<String, Object>>)sequence, segmentFile);
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(Map<String, Object> intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, intermediateRow));
    }

    protected List<Map<String, Object>> toMap(Map<String, Object> intermediateRow) {
        return Collections.singletonList(intermediateRow);
    }

    private Sequence<Map<String, Object>> cursorToSequence(Cursor cursor, Set<String> columnsToRead) {
        return Sequences.simple(() -> new IntermediateRowFromCursorIterator(cursor, columnsToRead));
    }

    @VisibleForTesting
    static CloseableIterator<Map<String, Object>> makeCloseableIteratorFromSequenceAndSegmentFile(final Sequence<Map<String, Object>> sequence, final InputEntity.CleanableFile segmentFile) {
        return new CloseableIterator<Map<String, Object>>(){
            Yielder<Map<String, Object>> rowYielder;
            {
                this.rowYielder = Yielders.each((Sequence)sequence);
            }

            public boolean hasNext() {
                return !this.rowYielder.isDone();
            }

            public Map<String, Object> next() {
                Map row = (Map)this.rowYielder.get();
                this.rowYielder = this.rowYielder.next(null);
                return row;
            }

            public void close() throws IOException {
                CloseableUtils.closeAll(this.rowYielder, (Closeable[])new Closeable[]{segmentFile});
            }
        };
    }

    private static class IntermediateRowFromCursorIterator
    implements Iterator<Map<String, Object>> {
        private final Cursor cursor;
        private final Map<String, Supplier<Object>> columnReaders;

        public IntermediateRowFromCursorIterator(Cursor cursor, Set<String> columnsToRead) {
            this.cursor = cursor;
            this.columnReaders = CollectionUtils.newLinkedHashMapWithExpectedSize((int)columnsToRead.size());
            for (String column : columnsToRead) {
                this.columnReaders.put(column, (Supplier<Object>)ColumnProcessors.makeProcessor((String)column, (ColumnProcessorFactory)IntermediateRowColumnProcessorFactory.INSTANCE, (ColumnSelectorFactory)cursor.getColumnSelectorFactory()));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.cursor.isDone();
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LinkedHashMap rowMap = CollectionUtils.newLinkedHashMapWithExpectedSize((int)this.columnReaders.size());
            for (Map.Entry<String, Supplier<Object>> entry : this.columnReaders.entrySet()) {
                Object value = entry.getValue().get();
                if (value == null) continue;
                rowMap.put(entry.getKey(), value);
            }
            this.cursor.advance();
            return rowMap;
        }
    }

    private static class IntermediateRowColumnProcessorFactory
    implements ColumnProcessorFactory<Supplier<Object>> {
        private static final IntermediateRowColumnProcessorFactory INSTANCE = new IntermediateRowColumnProcessorFactory();

        private IntermediateRowColumnProcessorFactory() {
        }

        public ColumnType defaultType() {
            return ColumnType.STRING;
        }

        public Supplier<Object> makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            return () -> {
                IndexedInts vals = selector.getRow();
                int valsSize = vals.size();
                if (valsSize == 1) {
                    return selector.lookupName(vals.get(0));
                }
                if (valsSize > 1) {
                    ArrayList<String> dimVals = new ArrayList<String>(valsSize);
                    for (int i = 0; i < valsSize; ++i) {
                        dimVals.add(selector.lookupName(vals.get(i)));
                    }
                    return dimVals;
                }
                return null;
            };
        }

        public Supplier<Object> makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            return () -> selector.isNull() ? null : Float.valueOf(selector.getFloat());
        }

        public Supplier<Object> makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            return () -> selector.isNull() ? null : Double.valueOf(selector.getDouble());
        }

        public Supplier<Object> makeLongProcessor(BaseLongColumnValueSelector selector) {
            return () -> selector.isNull() ? null : Long.valueOf(selector.getLong());
        }

        public Supplier<Object> makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return () -> selector.getObject();
        }
    }
}

