/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.ArrayOfStringsNullSafeSerde;

public class ArrayOfStringTuplesSerDe
extends ArrayOfItemsSerDe<StringTuple> {
    private static final ArrayOfStringsNullSafeSerde STRINGS_SERDE = new ArrayOfStringsNullSafeSerde();

    public byte[] serializeToByteArray(StringTuple[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            itemsBytes[i] = STRINGS_SERDE.serializeToByteArray(items[i].toArray());
            length += 8 + itemsBytes[i].length;
        }
        byte[] bytes = new byte[length];
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        long offsetBytes = 0L;
        for (int i = 0; i < items.length; ++i) {
            mem.putInt(offsetBytes, items[i].size());
            mem.putInt(offsetBytes += 4L, itemsBytes[i].length);
            mem.putByteArray(offsetBytes += 4L, itemsBytes[i], 0, itemsBytes[i].length);
            offsetBytes += (long)itemsBytes[i].length;
        }
        return bytes;
    }

    public StringTuple[] deserializeFromMemory(Memory mem, int numItems) {
        StringTuple[] array = new StringTuple[numItems];
        long offsetBytes = 0L;
        for (int i = 0; i < numItems; ++i) {
            UnsafeUtil.checkBounds((long)offsetBytes, (long)4L, (long)mem.getCapacity());
            int numItemsInTuple = mem.getInt(offsetBytes);
            UnsafeUtil.checkBounds((long)(offsetBytes += 4L), (long)4L, (long)mem.getCapacity());
            int byteContentSize = mem.getInt(offsetBytes);
            byte[] byteContent = new byte[byteContentSize];
            UnsafeUtil.checkBounds((long)(offsetBytes += 4L), (long)byteContentSize, (long)mem.getCapacity());
            mem.getByteArray(offsetBytes, byteContent, 0, byteContentSize);
            offsetBytes += (long)byteContentSize;
            array[i] = StringTuple.create((String[])STRINGS_SERDE.deserializeFromMemory(Memory.wrap((byte[])byteContent), numItemsInTuple));
        }
        return array;
    }
}

