/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TombstoneHelper {
    private final DataSchema dataSchema;
    private final TaskActionClient taskActionClient;
    private final Collection<DataSegment> pushedSegments;

    public TombstoneHelper(Collection<DataSegment> pushedSegments, DataSchema dataSchema, TaskActionClient taskActionClient) {
        Preconditions.checkNotNull(pushedSegments, (Object)"pushedSegments");
        Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        Preconditions.checkNotNull((Object)taskActionClient, (Object)"taskActionClient");
        this.dataSchema = dataSchema;
        this.taskActionClient = taskActionClient;
        this.pushedSegments = pushedSegments;
    }

    private List<Interval> getCondensedPushedSegmentsIntervals() {
        ArrayList<Interval> pushedSegmentsIntervals = new ArrayList<Interval>();
        for (DataSegment pushedSegment : this.pushedSegments) {
            pushedSegmentsIntervals.add(pushedSegment.getInterval());
        }
        return JodaUtils.condenseIntervals(pushedSegmentsIntervals);
    }

    public Set<DataSegment> computeTombstones(Map<Interval, SegmentIdWithShardSpec> tombstoneIntervalsAndVersions) {
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        String dataSource = this.dataSchema.getDataSource();
        for (Map.Entry<Interval, SegmentIdWithShardSpec> tombstoneIntervalAndVersion : tombstoneIntervalsAndVersions.entrySet()) {
            DataSegment tombstone = this.createTombstoneForTimeChunkInterval(dataSource, tombstoneIntervalAndVersion.getValue().getVersion(), tombstoneIntervalAndVersion.getValue().getShardSpec(), tombstoneIntervalAndVersion.getKey());
            retVal.add(tombstone);
        }
        return retVal;
    }

    public List<Interval> computeTombstoneIntervals() throws IOException {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        GranularitySpec granularitySpec = this.dataSchema.getGranularitySpec();
        List<Interval> pushedSegmentsIntervals = this.getCondensedPushedSegmentsIntervals();
        List<Interval> intervalsForUsedSegments = this.getCondensedUsedIntervals();
        block0: for (Interval timeChunkInterval : granularitySpec.sortedBucketIntervals()) {
            boolean isEmpty = true;
            for (Interval pushedSegmentCondensedInterval : pushedSegmentsIntervals) {
                if (!timeChunkInterval.overlaps((ReadableInterval)pushedSegmentCondensedInterval)) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            for (Interval usedSegmentInterval : intervalsForUsedSegments) {
                if (!timeChunkInterval.overlaps((ReadableInterval)usedSegmentInterval)) continue;
                retVal.add(timeChunkInterval);
                continue block0;
            }
        }
        return retVal;
    }

    private DataSegment createTombstoneForTimeChunkInterval(String dataSource, String version, ShardSpec shardSpec, Interval timeChunkInterval) {
        HashMap<String, String> tombstoneLoadSpec = new HashMap<String, String>();
        tombstoneLoadSpec.put("type", "tombstone");
        tombstoneLoadSpec.put("path", null);
        DataSegment.Builder dataSegmentBuilder = DataSegment.builder().dataSource(dataSource).interval(timeChunkInterval).version(version).shardSpec(shardSpec).loadSpec(tombstoneLoadSpec).size(1L);
        return dataSegmentBuilder.build();
    }

    public List<Interval> getCondensedUsedIntervals() throws IOException {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        List condensedInputIntervals = JodaUtils.condenseIntervals((Iterable)this.dataSchema.getGranularitySpec().inputIntervals());
        if (!condensedInputIntervals.isEmpty()) {
            Collection<DataSegment> usedSegmentsInInputInterval = this.taskActionClient.submit(new RetrieveUsedSegmentsAction(this.dataSchema.getDataSource(), null, condensedInputIntervals, Segments.ONLY_VISIBLE));
            block0: for (DataSegment usedSegment : usedSegmentsInInputInterval) {
                for (Interval condensedInputInterval : condensedInputIntervals) {
                    if (!condensedInputInterval.overlaps((ReadableInterval)usedSegment.getInterval())) continue;
                    retVal.add(usedSegment.getInterval());
                    continue block0;
                }
            }
        }
        return JodaUtils.condenseIntervals(retVal);
    }
}

