/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedPartitionsReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CircularBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

abstract class PartialSegmentGenerateTask<T extends GeneratedPartitionsReport>
extends PerfectRollupWorkerTask {
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;
    private final IndexTaskInputRowIteratorBuilder inputRowIteratorBuilder;
    private @MonotonicNonNull RowIngestionMeters buildSegmentsMeters;
    private @MonotonicNonNull ParseExceptionHandler parseExceptionHandler;

    PartialSegmentGenerateTask(String id, String groupId, TaskResource taskResource, String supervisorTaskId, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, IndexTaskInputRowIteratorBuilder inputRowIteratorBuilder) {
        super(id, groupId, taskResource, ingestionSchema.getDataSchema(), ingestionSchema.getTuningConfig(), context);
        Preconditions.checkArgument((!ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals().isEmpty() ? 1 : 0) != 0, (Object)"Missing intervals in granularitySpec");
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.inputRowIteratorBuilder = inputRowIteratorBuilder;
    }

    @Override
    public final TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(this.ingestionSchema.getDataSchema().getParser());
        ParallelIndexSupervisorTaskClient taskClient = toolbox.getSupervisorTaskClientProvider().build(this.supervisorTaskId, this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        List<DataSegment> segments = this.generateSegments(toolbox, taskClient, inputSource, toolbox.getIndexingTmpDir());
        Map<String, TaskReport> taskReport = this.getTaskCompletionReports();
        taskClient.report((SubTaskReport)this.createGeneratedPartitionsReport(toolbox, segments, taskReport));
        return TaskStatus.success((String)this.getId());
    }

    abstract SegmentAllocatorForBatch createSegmentAllocator(TaskToolbox var1, ParallelIndexSupervisorTaskClient var2) throws IOException;

    abstract T createGeneratedPartitionsReport(TaskToolbox var1, List<DataSegment> var2, Map<String, TaskReport> var3);

    /*
     * Exception decompiling
     */
    private List<DataSegment> generateSegments(TaskToolbox toolbox, ParallelIndexSupervisorTaskClient taskClient, InputSource inputSource, File tmpDir) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(IngestionState.COMPLETED, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), "", false, this.segmentAvailabilityWaitTimeMs)));
    }

    private Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        List<ParseExceptionReport> parseExceptionMessages = IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.parseExceptionHandler.getSavedParseExceptionReports());
        if (parseExceptionMessages != null) {
            unparseableEventsMap.put("buildSegments", parseExceptionMessages);
        } else {
            unparseableEventsMap.put("buildSegments", ImmutableList.of());
        }
        return unparseableEventsMap;
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }
}

