/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.utils.CircularBuffer;
import org.joda.time.DateTime;

public class IndexTaskUtils {
    @Nullable
    public static List<String> getMessagesFromSavedParseExceptions(CircularBuffer<ParseException> savedParseExceptions, boolean includeTimeOfException) {
        if (savedParseExceptions == null) {
            return null;
        }
        ArrayList<String> events = new ArrayList<String>();
        for (int i = 0; i < savedParseExceptions.size(); ++i) {
            if (includeTimeOfException) {
                DateTime timeOfException = DateTimes.utc((long)((ParseException)((Object)savedParseExceptions.getLatest(i))).getTimeOfExceptionMillis());
                events.add(timeOfException + ", " + ((ParseException)((Object)savedParseExceptions.getLatest(i))).getMessage());
                continue;
            }
            events.add(((ParseException)((Object)savedParseExceptions.getLatest(i))).getMessage());
        }
        return events;
    }

    @Nullable
    public static List<ParseExceptionReport> getReportListFromSavedParseExceptions(CircularBuffer<ParseExceptionReport> savedParseExceptionReports) {
        if (savedParseExceptionReports == null) {
            return null;
        }
        ArrayList<ParseExceptionReport> reports = new ArrayList<ParseExceptionReport>();
        for (int i = 0; i < savedParseExceptionReports.size(); ++i) {
            reports.add((ParseExceptionReport)savedParseExceptionReports.getLatest(i));
        }
        return reports;
    }

    public static Access datasourceAuthorizationCheck(HttpServletRequest req, Action action, String datasource, AuthorizerMapper authorizerMapper) {
        ResourceAction resourceAction = new ResourceAction(new Resource(datasource, "DATASOURCE"), action);
        Access access = AuthorizationUtils.authorizeResourceAction((HttpServletRequest)req, (ResourceAction)resourceAction, (AuthorizerMapper)authorizerMapper);
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
        return access;
    }

    public static void setTaskDimensions(ServiceMetricEvent.Builder metricBuilder, Task task) {
        metricBuilder.setDimension("taskId", (Object)task.getId());
        metricBuilder.setDimension("taskType", (Object)task.getType());
        metricBuilder.setDimension("dataSource", (Object)task.getDataSource());
    }

    public static void setTaskDimensions(ServiceMetricEvent.Builder metricBuilder, AbstractTask task) {
        metricBuilder.setDimension("taskId", (Object)task.getId());
        metricBuilder.setDimension("taskType", (Object)task.getType());
        metricBuilder.setDimension("dataSource", (Object)task.getDataSource());
        metricBuilder.setDimension("taskIngestionMode", (Object)task.getIngestionMode());
    }

    public static void setTaskStatusDimensions(ServiceMetricEvent.Builder metricBuilder, TaskStatus taskStatus) {
        metricBuilder.setDimension("taskId", (Object)taskStatus.getId());
        metricBuilder.setDimension("taskStatus", (Object)taskStatus.getStatusCode().toString());
    }
}

