/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class CompactionIntervalSpec
implements CompactionInputSpec {
    public static final String TYPE = "interval";
    private final Interval interval;
    @Nullable
    private final String sha256OfSortedSegmentIds;

    @JsonCreator
    public CompactionIntervalSpec(@JsonProperty(value="interval") Interval interval, @JsonProperty(value="sha256OfSortedSegmentIds") @Nullable String sha256OfSortedSegmentIds) {
        if (interval != null && interval.toDurationMillis() == 0L) {
            throw new IAE("Interval[%s] is empty, must specify a nonempty interval", new Object[]{interval});
        }
        this.interval = interval;
        this.sha256OfSortedSegmentIds = sha256OfSortedSegmentIds;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public String getSha256OfSortedSegmentIds() {
        return this.sha256OfSortedSegmentIds;
    }

    @Override
    public Interval findInterval(String dataSource) {
        return this.interval;
    }

    @Override
    public boolean validateSegments(LockGranularity lockGranularityInUse, List<DataSegment> latestSegments) {
        Interval segmentsInterval = JodaUtils.umbrellaInterval((Iterable)latestSegments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        if (this.interval.overlaps((ReadableInterval)segmentsInterval)) {
            if (this.sha256OfSortedSegmentIds != null) {
                String hashOfThem = SegmentUtils.hashIds(latestSegments);
                return hashOfThem.equals(this.sha256OfSortedSegmentIds);
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionIntervalSpec that = (CompactionIntervalSpec)o;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.sha256OfSortedSegmentIds, that.sha256OfSortedSegmentIds);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.sha256OfSortedSegmentIds);
    }

    public String toString() {
        return "CompactionIntervalSpec{interval=" + this.interval + ", sha256OfSegmentIds='" + this.sha256OfSortedSegmentIds + '\'' + '}';
    }
}

