/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.java.util.common.ISE;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class SegmentLock
implements TaskLock {
    static final String TYPE = "segment";
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final int partitionId;
    private final int priority;
    private final boolean revoked;

    @JsonCreator
    public SegmentLock(@JsonProperty(value="type") TaskLockType lockType, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="priority") int priority, @JsonProperty(value="revoked") boolean revoked) {
        this.lockType = (TaskLockType)((Object)Preconditions.checkNotNull((Object)((Object)lockType), (Object)"lockType"));
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.partitionId = partitionId;
        this.priority = priority;
        this.revoked = revoked;
    }

    public SegmentLock(TaskLockType lockType, String groupId, String dataSource, Interval interval, String version, int partitionId, int priority) {
        this(lockType, groupId, dataSource, interval, version, partitionId, priority, false);
    }

    @Override
    public TaskLock revokedCopy() {
        return new SegmentLock(this.lockType, this.groupId, this.dataSource, this.interval, this.version, this.partitionId, this.priority, true);
    }

    @Override
    public TaskLock withPriority(int newPriority) {
        return new SegmentLock(this.lockType, this.groupId, this.dataSource, this.interval, this.version, this.partitionId, newPriority, this.revoked);
    }

    @Override
    public LockGranularity getGranularity() {
        return LockGranularity.SEGMENT;
    }

    @Override
    @JsonProperty
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public int getNonNullPriority() {
        return this.priority;
    }

    @Override
    @JsonProperty
    public boolean isRevoked() {
        return this.revoked;
    }

    @Override
    public boolean conflict(LockRequest request) {
        if (request instanceof LockRequestForNewSegment) {
            return false;
        }
        if (!this.dataSource.equals(request.getDataSource())) {
            return false;
        }
        if (request instanceof TimeChunkLockRequest) {
            return this.interval.overlaps((ReadableInterval)request.getInterval());
        }
        if (request instanceof SpecificSegmentLockRequest) {
            if (this.interval.equals((Object)request.getInterval())) {
                SpecificSegmentLockRequest specificSegmentLockRequest = (SpecificSegmentLockRequest)request;
                return specificSegmentLockRequest.getPartitionId() == this.partitionId;
            }
            return this.interval.overlaps((ReadableInterval)request.getInterval());
        }
        throw new ISE("Unknown request type[%s]", new Object[]{request.getClass().getName()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentLock that = (SegmentLock)o;
        return this.partitionId == that.partitionId && this.priority == that.priority && this.revoked == that.revoked && this.lockType == that.lockType && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lockType, this.groupId, this.dataSource, this.interval, this.partitionId, this.version, this.priority, this.revoked});
    }

    public String toString() {
        return "SegmentLock{lockType=" + (Object)((Object)this.lockType) + ", groupId='" + this.groupId + '\'' + ", dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", version='" + this.version + '\'' + ", partitionId=" + this.partitionId + ", priority=" + this.priority + ", revoked=" + this.revoked + '}';
    }
}

