/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.indexer.DataSegmentAndIndexZipFilePath;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.IndexGeneratorJob;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.MetadataStorageUpdaterJobHandler;

public class MetadataStorageUpdaterJob
implements Jobby {
    private final HadoopDruidIndexerConfig config;
    private final MetadataStorageUpdaterJobHandler handler;

    public MetadataStorageUpdaterJob(HadoopDruidIndexerConfig config, MetadataStorageUpdaterJobHandler handler) {
        this.config = config;
        this.handler = handler;
    }

    public boolean run() {
        List<DataSegmentAndIndexZipFilePath> segmentAndIndexZipFilePaths = IndexGeneratorJob.getPublishedSegmentAndIndexZipFilePaths(this.config);
        List segments = segmentAndIndexZipFilePaths.stream().map(s -> s.getSegment()).collect(Collectors.toList());
        String segmentTable = this.config.getSchema().getIOConfig().getMetadataUpdateSpec().getSegmentTable();
        this.handler.publishSegments(segmentTable, segments, HadoopDruidIndexerConfig.JSON_MAPPER);
        return true;
    }
}

