/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.joda.time.DateTime;

public class Bucket {
    public static final int PREAMBLE_BYTES = 16;
    private final int shardNum;
    public final DateTime time;
    public final int partitionNum;

    public Bucket(int shardNum, DateTime time, int partitionNum) {
        this.shardNum = shardNum;
        this.time = time;
        this.partitionNum = partitionNum;
    }

    public byte[] toGroupKey(byte[] ... parts) {
        ByteBuffer buf = ByteBuffer.allocate(16 + Bucket.sizes(parts));
        buf.putInt(this.shardNum);
        buf.putLong(this.time.getMillis());
        buf.putInt(this.partitionNum);
        for (byte[] part : parts) {
            buf.put(part);
        }
        return buf.array();
    }

    public String toString() {
        return "Bucket{time=" + this.time + ", partitionNum=" + this.partitionNum + ", shardNum=" + this.shardNum + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        if (this.partitionNum != bucket.partitionNum) {
            return false;
        }
        if (this.shardNum != bucket.shardNum) {
            return false;
        }
        return !(this.time != null ? !this.time.equals((Object)bucket.time) : bucket.time != null);
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 31 * result + this.partitionNum;
        result = 31 * result + this.shardNum;
        return result;
    }

    private static int sizes(byte[] ... parts) {
        int size = 0;
        for (byte[] part : parts) {
            size += part.length;
        }
        return size;
    }

    public static Pair<Bucket, byte[]> fromGroupKey(byte[] keyBytes) {
        ByteBuffer buf = ByteBuffer.wrap(keyBytes);
        Bucket bucket = new Bucket(buf.getInt(), DateTimes.utc((long)buf.getLong()), buf.getInt());
        byte[] bytesLeft = new byte[buf.remaining()];
        buf.get(bytesLeft);
        return Pair.of((Object)bucket, (Object)bytesLeft);
    }

    @VisibleForTesting
    protected int getShardNum() {
        return this.shardNum;
    }
}

