/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.transform.DelegatingNamespaceContext;
import org.apache.cxf.staxutils.transform.ElementProperty;
import org.apache.cxf.staxutils.transform.QNamesMap;
import org.apache.cxf.staxutils.transform.TransformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InTransformReader
extends DepthXMLStreamReader {
    private static final String INTERN_NAMES = "org.codehaus.stax2.internNames";
    private static final String INTERN_NS = "org.codehaus.stax2.internNsUris";
    private Stack<QName> elementStack = new Stack();
    private QNamesMap inElementsMap;
    private QNamesMap inAttributesMap;
    private Map<QName, ElementProperty> inAppendMap = new HashMap<QName, ElementProperty>(5);
    private Set<QName> inDropSet = new HashSet<QName>(5);
    private Map<String, String> nsMap = new HashMap<String, String>(5);
    private QName currentQName;
    private QName pushBackQName;
    private QName pushAheadQName;
    private String replaceText;
    private String currentText;
    private String pushAheadText;
    private List<Integer> attributesIndexes = new ArrayList<Integer>();
    private int previousDepth = -1;
    private boolean blockOriginalReader = true;
    private boolean attributesIndexed;
    private DelegatingNamespaceContext namespaceContext;

    public InTransformReader(XMLStreamReader reader, Map<String, String> inMap, Map<String, String> appendMap, boolean blockOriginalReader) {
        this(reader, inMap, appendMap, null, null, blockOriginalReader);
    }

    public InTransformReader(XMLStreamReader reader, Map<String, String> inEMap, Map<String, String> appendMap, List<String> dropESet, Map<String, String> inAMap, boolean blockOriginalReader) {
        super(reader);
        this.inElementsMap = new QNamesMap(inEMap == null ? 0 : inEMap.size());
        this.inAttributesMap = new QNamesMap(inAMap == null ? 0 : inAMap.size());
        this.blockOriginalReader = blockOriginalReader;
        TransformUtils.convertToQNamesMap(inEMap, this.inElementsMap, this.nsMap);
        TransformUtils.convertToQNamesMap(inAMap, this.inAttributesMap, null);
        TransformUtils.convertToMapOfElementProperties(appendMap, this.inAppendMap);
        TransformUtils.convertToSetOfQNames(dropESet, this.inDropSet);
        this.namespaceContext = new DelegatingNamespaceContext(reader.getNamespaceContext(), this.nsMap);
    }

    @Override
    public XMLStreamReader getReader() {
        return this.blockOriginalReader ? this : super.getReader();
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.isAtText()) {
            this.resetCurrentText();
            return this.currentText != null ? 4 : 2;
        }
        if (this.isAtPushedQName()) {
            this.resetCurrentQName();
            this.pushElement();
            return 1;
        }
        if (this.isAtMarkedDepth()) {
            this.previousDepth = -1;
            this.popElement();
            return 2;
        }
        int event = super.next();
        if (event == 1) {
            this.attributesIndexed = false;
            QName theName = super.getName();
            ElementProperty appendProp = this.inAppendMap.remove(theName);
            boolean replaceContent = appendProp != null && theName.equals(appendProp.getName());
            boolean dropped = this.inDropSet.contains(theName);
            if (appendProp != null && !replaceContent) {
                if (appendProp.isChild()) {
                    this.pushAheadQName = appendProp.getName();
                } else {
                    this.currentQName = appendProp.getName();
                }
                if (appendProp.getText() != null) {
                    this.pushAheadText = appendProp.getText();
                } else {
                    this.previousDepth = this.getDepth();
                    this.pushElement();
                }
            } else if (dropped) {
                this.previousDepth = this.getDepth();
                return super.next();
            }
            QName expected = this.inElementsMap.get(theName);
            if (expected == null) {
                expected = theName;
            } else if (this.isEmpty(expected)) {
                int depth = this.getDepth();
                while (depth != this.getDepth() || super.next() != 2) {
                }
                this.popElement();
                return 2;
            }
            if (appendProp != null && appendProp.isChild() && !replaceContent) {
                this.currentQName = expected;
            } else if (appendProp != null && !appendProp.isChild() && !replaceContent) {
                this.pushBackQName = expected;
            } else {
                this.currentQName = expected;
                if (replaceContent) {
                    this.replaceText = appendProp.getText();
                }
                this.pushElement();
            }
        } else if (event == 2) {
            QName theName = super.getName();
            boolean dropped = this.inDropSet.contains(theName);
            if (dropped) {
                super.next();
            }
            this.popElement();
        } else {
            this.currentQName = null;
            this.currentText = null;
        }
        return event;
    }

    private boolean isAtText() {
        return this.pushAheadQName == null && (this.pushAheadText != null || this.currentText != null);
    }

    private boolean isAtPushedQName() {
        return this.pushBackQName != null || this.pushAheadQName != null;
    }

    private boolean isAtMarkedDepth() {
        return this.previousDepth != -1 && this.previousDepth == this.getDepth() + 1;
    }

    private boolean isEmpty(QName qname) {
        return "".equals(qname.getNamespaceURI()) && "".equals(qname.getLocalPart());
    }

    private void popElement() {
        this.currentQName = this.elementStack.empty() ? null : this.elementStack.pop();
    }

    private void pushElement() {
        this.elementStack.push(this.currentQName);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (INTERN_NAMES.equals(name) || INTERN_NS.equals(name)) {
            return Boolean.FALSE;
        }
        return super.getProperty(name);
    }

    @Override
    public String getLocalName() {
        if (this.currentQName != null) {
            return this.currentQName.getLocalPart();
        }
        return super.getLocalName();
    }

    private void resetCurrentQName() {
        this.currentQName = this.pushBackQName != null ? this.pushBackQName : this.pushAheadQName;
        this.pushBackQName = null;
        this.pushAheadQName = null;
    }

    private void resetCurrentText() {
        this.currentText = this.pushAheadText;
        this.pushAheadText = null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public String getPrefix() {
        QName name = this.readCurrentElement();
        String prefix = name.getPrefix();
        if (prefix.length() == 0) {
            prefix = this.namespaceContext.findUniquePrefix(name.getNamespaceURI());
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return actualNs;
        }
        return ns;
    }

    @Override
    public String getNamespacePrefix(int index) {
        String ns = super.getNamespaceURI(index);
        String actualNs = this.nsMap.get(ns);
        if (actualNs != null) {
            return this.namespaceContext.findUniquePrefix(actualNs);
        }
        return this.namespaceContext.getPrefix(ns);
    }

    @Override
    public String getNamespaceURI() {
        if (this.currentQName != null) {
            return this.currentQName.getNamespaceURI();
        }
        return super.getNamespaceURI();
    }

    private QName readCurrentElement() {
        if (this.currentQName != null) {
            return this.currentQName;
        }
        String ns = super.getNamespaceURI();
        String name = super.getLocalName();
        String prefix = super.getPrefix();
        return new QName(ns, name, prefix == null ? "" : prefix);
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName());
    }

    @Override
    public int getAttributeCount() {
        if (this.pushBackQName != null) {
            return 0;
        }
        this.checkAttributeIndexRange(-1);
        return this.attributesIndexes.size();
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return this.getAttributeName(arg0).getLocalPart();
    }

    @Override
    public QName getAttributeName(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        QName aname = super.getAttributeName(this.attributesIndexes.get(arg0));
        QName expected = this.inAttributesMap.get(aname);
        return expected == null ? aname : expected;
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return this.getAttributeName(arg0).getNamespaceURI();
    }

    @Override
    public String getAttributePrefix(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        QName aname = this.getAttributeName(arg0);
        if ("".equals(aname.getNamespaceURI())) {
            return "";
        }
        String actualNs = this.nsMap.get(aname.getNamespaceURI());
        if (actualNs != null) {
            return this.namespaceContext.findUniquePrefix(actualNs);
        }
        return this.namespaceContext.getPrefix(aname.getNamespaceURI());
    }

    @Override
    public String getAttributeType(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return super.getAttributeType(this.attributesIndexes.get(arg0));
    }

    @Override
    public String getAttributeValue(int arg0) {
        if (this.pushBackQName != null) {
            this.throwIndexException(arg0, 0);
        }
        this.checkAttributeIndexRange(arg0);
        return super.getAttributeValue(this.attributesIndexes.get(arg0));
    }

    @Override
    public String getAttributeValue(String namespace, String localName) {
        if (this.pushBackQName != null) {
            return null;
        }
        this.checkAttributeIndexRange(-1);
        return super.getAttributeValue(namespace, localName);
    }

    @Override
    public String getText() {
        if (this.currentText != null) {
            return this.currentText;
        }
        String superText = super.getText();
        if (this.replaceText != null) {
            superText = this.replaceText;
            this.replaceText = null;
        }
        return superText;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.currentText != null) {
            return this.currentText.toCharArray();
        }
        char[] superChars = super.getTextCharacters();
        if (this.replaceText != null) {
            superChars = this.replaceText.toCharArray();
            this.replaceText = null;
        }
        return superChars;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.currentText != null) {
            int len = this.currentText.length() - sourceStart;
            if (len > length) {
                len = length;
            }
            this.currentText.getChars(sourceStart, sourceStart + len, target, targetStart);
            return len;
        }
        return super.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        if (this.currentText != null) {
            return this.currentText.length();
        }
        return super.getTextLength();
    }

    private void checkAttributeIndexRange(int index) {
        if (!this.attributesIndexed) {
            this.attributesIndexes.clear();
            int c = super.getAttributeCount();
            for (int i = 0; i < c; ++i) {
                QName aname = super.getAttributeName(i);
                QName expected = this.inAttributesMap.get(aname);
                if (expected != null && this.isEmpty(expected)) continue;
                this.attributesIndexes.add(i);
            }
            this.attributesIndexed = true;
        }
        if (index >= this.attributesIndexes.size()) {
            this.throwIndexException(index, this.attributesIndexes.size());
        }
    }

    private void throwIndexException(int index, int size) {
        throw new IllegalArgumentException("Invalid index " + index + "; current element has only " + size + " attributes");
    }
}

