/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.ServerSocketChannel;
import org.apache.curator.test.Compatibility;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.TestingZooKeeperMain;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

class TestingQuorumPeerMain
extends QuorumPeerMain
implements ZooKeeperMainFace {
    private volatile boolean isClosed = false;

    TestingQuorumPeerMain() {
    }

    @Override
    public void kill() {
        try {
            if (this.quorumPeer != null) {
                Field cnxnFactoryField = QuorumPeer.class.getDeclaredField("cnxnFactory");
                cnxnFactoryField.setAccessible(true);
                ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)cnxnFactoryField.get(this.quorumPeer);
                Compatibility.serverCnxnFactoryCloseAll(cnxnFactory);
                Field ssField = cnxnFactory.getClass().getDeclaredField("ss");
                ssField.setAccessible(true);
                ServerSocketChannel ss = (ServerSocketChannel)ssField.get(cnxnFactory);
                ss.close();
            }
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public QuorumPeer getTestingQuorumPeer() {
        return this.quorumPeer;
    }

    @Override
    public void close() throws IOException {
        if (this.quorumPeer != null && !this.isClosed) {
            this.isClosed = true;
            this.quorumPeer.shutdown();
        }
    }

    @Override
    public void blockUntilStarted() {
        long startTime = System.currentTimeMillis();
        while (this.quorumPeer == null && System.currentTimeMillis() - startTime <= (long)TestingZooKeeperMain.MAX_WAIT_MS) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.quorumPeer == null) {
            throw new FailedServerStartException("quorumPeer never got set");
        }
    }
}

