/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test.compatibility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.test.Compatibility;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;

public class Zk35MethodInterceptor
implements IMethodInterceptor {
    public static final String zk35Group = "zk35";

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        if (!Compatibility.isZK34()) {
            return methods;
        }
        ArrayList<IMethodInstance> filteredMethods = new ArrayList<IMethodInstance>();
        for (IMethodInstance method : methods) {
            if (this.isInGroup(method.getMethod().getGroups())) continue;
            filteredMethods.add(method);
        }
        return filteredMethods;
    }

    private boolean isInGroup(String[] groups) {
        return groups != null && Arrays.asList(groups).contains(zk35Group);
    }
}

