/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

class PathChildrenCacheListenerWrapper
implements CuratorCacheListener {
    private final PathChildrenCacheListener listener;
    private final CuratorFramework client;

    PathChildrenCacheListenerWrapper(CuratorFramework client, PathChildrenCacheListener listener) {
        this.listener = listener;
        this.client = client;
    }

    @Override
    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        switch (type) {
            case NODE_CREATED: {
                this.sendEvent(data, PathChildrenCacheEvent.Type.CHILD_ADDED);
                break;
            }
            case NODE_CHANGED: {
                this.sendEvent(data, PathChildrenCacheEvent.Type.CHILD_UPDATED);
                break;
            }
            case NODE_DELETED: {
                this.sendEvent(oldData, PathChildrenCacheEvent.Type.CHILD_REMOVED);
            }
        }
    }

    @Override
    public void initialized() {
        this.sendEvent(null, PathChildrenCacheEvent.Type.INITIALIZED);
    }

    private void sendEvent(ChildData node, PathChildrenCacheEvent.Type type) {
        PathChildrenCacheEvent event = new PathChildrenCacheEvent(type, node);
        try {
            this.listener.childEvent(this.client, event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

