/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.CuratorCacheListenerBuilder;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.NodeCacheListenerWrapper;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListenerWrapper;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheListenerWrapper;

class CuratorCacheListenerBuilderImpl
implements CuratorCacheListenerBuilder {
    private final List<CuratorCacheListener> listeners = new ArrayList<CuratorCacheListener>();
    private boolean afterInitializedOnly = false;

    CuratorCacheListenerBuilderImpl() {
    }

    @Override
    public CuratorCacheListenerBuilder forAll(CuratorCacheListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forCreates(Consumer<ChildData> listener) {
        this.listeners.add((type, oldNode, node) -> {
            if (type == CuratorCacheListener.Type.NODE_CREATED) {
                listener.accept(node);
            }
        });
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forChanges(CuratorCacheListenerBuilder.ChangeListener listener) {
        this.listeners.add((type, oldNode, node) -> {
            if (type == CuratorCacheListener.Type.NODE_CHANGED) {
                listener.event(oldNode, node);
            }
        });
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forCreatesAndChanges(CuratorCacheListenerBuilder.ChangeListener listener) {
        this.listeners.add((type, oldNode, node) -> {
            if (type == CuratorCacheListener.Type.NODE_CHANGED || type == CuratorCacheListener.Type.NODE_CREATED) {
                listener.event(oldNode, node);
            }
        });
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forDeletes(Consumer<ChildData> listener) {
        this.listeners.add((type, oldNode, node) -> {
            if (type == CuratorCacheListener.Type.NODE_DELETED) {
                listener.accept(oldNode);
            }
        });
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forInitialized(final Runnable listener) {
        CuratorCacheListener localListener = new CuratorCacheListener(){

            @Override
            public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
            }

            @Override
            public void initialized() {
                listener.run();
            }
        };
        this.listeners.add(localListener);
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forPathChildrenCache(CuratorFramework client, PathChildrenCacheListener listener) {
        this.listeners.add(new PathChildrenCacheListenerWrapper(client, listener));
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forTreeCache(CuratorFramework client, TreeCacheListener listener) {
        this.listeners.add(new TreeCacheListenerWrapper(client, listener));
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder forNodeCache(NodeCacheListener listener) {
        this.listeners.add(new NodeCacheListenerWrapper(listener));
        return this;
    }

    @Override
    public CuratorCacheListenerBuilder afterInitialized() {
        this.afterInitializedOnly = true;
        return this;
    }

    @Override
    public CuratorCacheListener build() {
        final ArrayList<CuratorCacheListener> copy = new ArrayList<CuratorCacheListener>(this.listeners);
        return new CuratorCacheListener(){
            private volatile boolean isInitialized;
            {
                this.isInitialized = !CuratorCacheListenerBuilderImpl.this.afterInitializedOnly;
            }

            @Override
            public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
                if (this.isInitialized) {
                    copy.forEach(l -> l.event(type, oldData, data));
                }
            }

            @Override
            public void initialized() {
                this.isInitialized = true;
                copy.forEach(CuratorCacheListener::initialized);
            }
        };
    }
}

