/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class JexlArithmetic {
    protected static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    protected static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    protected static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private boolean strict;

    public JexlArithmetic(boolean lenient) {
        this.strict = !lenient;
    }

    void setLenient(boolean lenient) {
        this.strict = !lenient;
    }

    public boolean isLenient() {
        return !this.strict;
    }

    protected Object controlNullNullOperands() {
        if (this.strict) {
            throw new NullPointerException("jexl.null");
        }
        return 0;
    }

    protected void controlNullOperand() {
        if (this.strict) {
            throw new NullPointerException("jexl.null");
        }
    }

    protected boolean isFloatingPointType(Object left, Object right) {
        return left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double;
    }

    protected boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof String) {
            String string = (String)val;
            return string.indexOf(46) != -1 || string.indexOf(101) != -1 || string.indexOf(69) != -1;
        }
        return false;
    }

    protected boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    protected boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }

    protected Number narrowBigInteger(Object lhs, Object rhs, BigInteger bigi) {
        if (!(lhs instanceof BigInteger) && !(rhs instanceof BigInteger) && bigi.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigi.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigi.longValue();
            if (!(lhs instanceof Long) && !(rhs instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
            return l;
        }
        return bigi;
    }

    protected Object narrowArrayType(Object[] untyped) {
        int size = untyped.length;
        Class commonClass = null;
        if (size > 0) {
            commonClass = untyped[0].getClass();
            boolean isNumber = Number.class.isAssignableFrom(commonClass);
            for (int i = 1; i < size; ++i) {
                Class<?> eclass = untyped[i].getClass();
                if (Object.class.equals(commonClass) || commonClass.equals(eclass)) continue;
                commonClass = isNumber && Number.class.isAssignableFrom(eclass) ? Number.class : Object.class;
            }
            if (!Object.class.equals(commonClass)) {
                if (isNumber) {
                    try {
                        Field TYPE = commonClass.getField("TYPE");
                        commonClass = (Class)TYPE.get(null);
                    }
                    catch (Exception xany) {
                        // empty catch block
                    }
                }
                Object typed = Array.newInstance(commonClass, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(typed, i, untyped[i]);
                }
                return typed;
            }
        }
        return untyped;
    }

    protected boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        for (int a = 0; a < args.length; ++a) {
            Object arg = args[a];
            if (!(arg instanceof Number)) continue;
            Number narg = this.narrow((Number)arg);
            if (narg != arg) {
                narrowed = true;
            }
            args[a] = narg;
        }
        return narrowed;
    }

    public Object add(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        try {
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return new Double(l + r);
            }
            if (left instanceof BigInteger && right instanceof BigInteger) {
                BigInteger l = this.toBigInteger(left);
                BigInteger r = this.toBigInteger(right);
                return l.add(r);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                return l.add(r);
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            BigInteger result = l.add(r);
            return this.narrowBigInteger(left, right, result);
        }
        catch (NumberFormatException nfe) {
            return this.toString(left).concat(this.toString(right));
        }
    }

    public Object divide(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("/");
            }
            return new Double(l / r);
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            return l.divide(r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            BigDecimal d = l.divide(r);
            return d;
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.divide(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object mod(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("%");
            }
            return new Double(l % r);
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            return l.mod(r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            BigDecimal remainder = l.remainder(r);
            return remainder;
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.mod(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object multiply(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            return new Double(l * r);
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            return l.multiply(r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            return l.multiply(r);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.multiply(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object subtract(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands();
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(left);
            double r = this.toDouble(right);
            return new Double(l - r);
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            return l.subtract(r);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(left);
            BigDecimal r = this.toBigDecimal(right);
            return l.subtract(r);
        }
        BigInteger l = this.toBigInteger(left);
        BigInteger r = this.toBigInteger(right);
        BigInteger result = l.subtract(r);
        return this.narrowBigInteger(left, right, result);
    }

    public boolean matches(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        String arg = left.toString();
        if (right instanceof Pattern) {
            return ((Pattern)right).matcher(arg).matches();
        }
        return arg.matches(right.toString());
    }

    public boolean equals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right);
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return this.toBigDecimal(left).compareTo(this.toBigDecimal(right)) == 0;
        }
        if (this.isFloatingPointType(left, right)) {
            return this.toDouble(left) == this.toDouble(right);
        }
        if (left instanceof Number || right instanceof Number || left instanceof Character || right instanceof Character) {
            return this.toLong(left) == this.toLong(right);
        }
        if (left instanceof Boolean || right instanceof Boolean) {
            return this.toBoolean(left) == this.toBoolean(right);
        }
        if (left instanceof String || right instanceof String) {
            return left.toString().equals(right.toString());
        }
        return left.equals(right);
    }

    public boolean lessThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        if (this.isFloatingPoint(left) || this.isFloatingPoint(right)) {
            double rightDouble;
            double leftDouble = this.toDouble(left);
            return leftDouble < (rightDouble = this.toDouble(right));
        }
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal r;
            BigDecimal l = this.toBigDecimal(left);
            return l.compareTo(r = this.toBigDecimal(right)) < 0;
        }
        if (this.isNumberable(left) || this.isNumberable(right)) {
            long rightLong;
            long leftLong = this.toLong(left);
            return leftLong < (rightLong = this.toLong(right));
        }
        if (left instanceof String || right instanceof String) {
            String rightString;
            String leftString = left.toString();
            return leftString.compareTo(rightString = right.toString()) < 0;
        }
        if (left instanceof Comparable) {
            Comparable comparable = (Comparable)left;
            return comparable.compareTo(right) < 0;
        }
        if (right instanceof Comparable) {
            Comparable comparable = (Comparable)right;
            return comparable.compareTo(left) > 0;
        }
        throw new IllegalArgumentException("Invalid comparison : comparing cardinality for left: " + left + " and right: " + right);
    }

    public boolean greaterThan(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        return !this.equals(left, right) && !this.lessThan(left, right);
    }

    public boolean lessThanOrEqual(Object left, Object right) {
        return this.equals(left, right) || this.lessThan(left, right);
    }

    public boolean greaterThanOrEqual(Object left, Object right) {
        return this.equals(left, right) || this.greaterThan(left, right);
    }

    public boolean toBoolean(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return false;
    }

    public int toInteger(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0;
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0;
            }
            return Integer.parseInt((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Integer coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new IllegalArgumentException("Integer coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public long toLong(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0L;
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0L;
            }
            return Long.parseLong((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new NumberFormatException("Boolean->Long coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        throw new NumberFormatException("Long coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public BigInteger toBigInteger(Object val) {
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val == null) {
            this.controlNullOperand();
            return BigInteger.valueOf(0L);
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigInteger.ZERO;
            }
            return new BigInteger(string);
        }
        if (val instanceof Number) {
            return new BigInteger(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        throw new IllegalArgumentException("BigInteger coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val == null) {
            this.controlNullOperand();
            return BigDecimal.ZERO;
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(string);
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new BigDecimal(i);
        }
        throw new IllegalArgumentException("BigDecimal coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public double toDouble(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return 0.0;
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return i;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return Double.parseDouble(String.valueOf(val));
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Double coercion exception");
        }
        throw new IllegalArgumentException("Double coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public String toString(Object val) {
        if (val == null) {
            this.controlNullOperand();
            val = "";
        }
        return val.toString();
    }

    public Number narrow(Number original) {
        BigDecimal bigd;
        if (original == null) {
            return original;
        }
        Number result = original;
        if (original instanceof BigDecimal && (bigd = (BigDecimal)original).compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
            return original;
        }
        if (original instanceof Double || original instanceof Float || original instanceof BigDecimal) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(result.floatValue());
            }
        } else {
            BigInteger bigi;
            if (original instanceof BigInteger && ((bigi = (BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || bigi.compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            if (value <= 127L && value >= -128L) {
                result = (byte)value;
            } else if (value <= 32767L && value >= -32768L) {
                result = (short)value;
            } else if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = (int)value;
            }
        }
        return result;
    }
}

