/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.checksum;

import com.scurrilous.circe.checksum.IntHash;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java9IntHash
implements IntHash {
    private static final Logger log = LoggerFactory.getLogger(Java9IntHash.class);
    static final boolean HAS_JAVA9_CRC32C;
    private static final Method UPDATE_BYTES;
    private static final Method UPDATE_DIRECT_BYTEBUFFER;
    private static final String CRC32C_CLASS_NAME = "java.util.zip.CRC32C";
    private static final FastThreadLocal<byte[]> TL_BUFFER;

    @Override
    public int calculate(ByteBuf buffer) {
        return this.resume(0, buffer);
    }

    private int resume(int current, long address, int offset, int length) {
        try {
            return (Integer)UPDATE_DIRECT_BYTEBUFFER.invoke(null, current, address, offset, offset + length);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private int resume(int current, byte[] array, int offset, int length) {
        try {
            return (Integer)UPDATE_BYTES.invoke(null, current, array, offset, offset + length);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int resume(int current, ByteBuf buffer) {
        int negCrc = ~current;
        if (buffer.hasMemoryAddress()) {
            negCrc = this.resume(negCrc, buffer.memoryAddress(), buffer.readerIndex(), buffer.readableBytes());
        } else if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.readerIndex();
            negCrc = this.resume(negCrc, buffer.array(), offset, buffer.readableBytes());
        } else {
            int length;
            byte[] b = (byte[])TL_BUFFER.get();
            for (int toRead = buffer.readableBytes(); toRead > 0; toRead -= length) {
                length = Math.min(toRead, b.length);
                buffer.readBytes(b, 0, length);
                negCrc = this.resume(negCrc, b, 0, length);
            }
        }
        return ~negCrc;
    }

    static {
        TL_BUFFER = new FastThreadLocal<byte[]>(){

            protected byte[] initialValue() {
                return new byte[4096];
            }
        };
        boolean hasJava9CRC32C = false;
        Method updateBytes = null;
        Method updateDirectByteBuffer = null;
        try {
            Class<?> c = Class.forName(CRC32C_CLASS_NAME);
            updateBytes = c.getDeclaredMethod("updateBytes", Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
            updateBytes.setAccessible(true);
            updateDirectByteBuffer = c.getDeclaredMethod("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            updateDirectByteBuffer.setAccessible(true);
            hasJava9CRC32C = true;
        }
        catch (Exception e) {
            log.debug("Unable to use reflected methods: ", (Throwable)e);
            updateBytes = null;
            updateDirectByteBuffer = null;
        }
        HAS_JAVA9_CRC32C = hasJava9CRC32C;
        UPDATE_BYTES = updateBytes;
        UPDATE_DIRECT_BYTEBUFFER = updateDirectByteBuffer;
    }
}

