/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.command.AbstractCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJmxCommand
extends AbstractCommand {
    public static final String DEFAULT_JMX_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi";
    private JMXServiceURL jmxServiceUrl;
    private String jmxUser;
    private String jmxPassword;
    private boolean jmxUseLocal;
    private JMXConnector jmxConnector;
    private MBeanServerConnection jmxConnection;

    protected JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    protected JMXServiceURL useJmxServiceUrl() throws MalformedURLException {
        if (this.getJmxServiceUrl() == null) {
            this.setJmxServiceUrl(DEFAULT_JMX_URL);
        }
        return this.getJmxServiceUrl();
    }

    protected void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    protected void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    public String getJmxUser() {
        return this.jmxUser;
    }

    public void setJmxUser(String jmxUser) {
        this.jmxUser = jmxUser;
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public void setJmxPassword(String jmxPassword) {
        this.jmxPassword = jmxPassword;
    }

    public boolean isJmxUseLocal() {
        return this.jmxUseLocal;
    }

    public void setJmxUseLocal(boolean jmxUseLocal) {
        this.jmxUseLocal = jmxUseLocal;
    }

    private JMXConnector createJmxConnector() throws IOException {
        if (this.jmxConnector != null) {
            this.jmxConnector.connect();
            return this.jmxConnector;
        }
        if (this.jmxUser != null && this.jmxPassword != null) {
            HashMap<String, String[]> props = new HashMap<String, String[]>();
            props.put("jmx.remote.credentials", new String[]{this.jmxUser, this.jmxPassword});
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl(), props);
        } else {
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl());
        }
        return this.jmxConnector;
    }

    protected void closeJmxConnection() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected MBeanServerConnection createJmxConnection() throws IOException {
        if (this.jmxConnection == null) {
            this.jmxConnection = this.isJmxUseLocal() ? ManagementFactory.getPlatformMBeanServer() : this.createJmxConnector().getMBeanServerConnection();
        }
        return this.jmxConnection;
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.equals("--jmxurl")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX URL not specified."));
            }
            if (this.getJmxServiceUrl() != null) {
                this.context.printException(new IllegalArgumentException("Multiple JMX URL cannot be specified."));
                tokens.clear();
            }
            String strJmxUrl = tokens.remove(0);
            try {
                this.setJmxServiceUrl(new JMXServiceURL(strJmxUrl));
            }
            catch (MalformedURLException e) {
                this.context.printException(e);
                tokens.clear();
            }
        } else if (token.equals("--jmxuser")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX user not specified."));
            }
            this.setJmxUser(tokens.remove(0));
        } else if (token.equals("--jmxpassword")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX password not specified."));
            }
            this.setJmxPassword(tokens.remove(0));
        } else if (token.equals("--jmxlocal")) {
            this.setJmxUseLocal(true);
        } else {
            super.handleOption(token, tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<String> tokens) throws Exception {
        try {
            super.execute(tokens);
        }
        finally {
            this.closeJmxConnection();
        }
    }
}

