/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.util.BitSet;
import org.apache.oro.text.awk.SyntaxNode;

final class CatNode
extends SyntaxNode {
    SyntaxNode _left;
    SyntaxNode _right;

    CatNode() {
    }

    @Override
    boolean _nullable() {
        return this._left._nullable() && this._right._nullable();
    }

    @Override
    BitSet _firstPosition() {
        if (this._left._nullable()) {
            BitSet ls = this._left._firstPosition();
            BitSet rs = this._right._firstPosition();
            BitSet bs = new BitSet(Math.max(ls.size(), rs.size()));
            bs.or(rs);
            bs.or(ls);
            return bs;
        }
        return this._left._firstPosition();
    }

    @Override
    BitSet _lastPosition() {
        if (this._right._nullable()) {
            BitSet ls = this._left._lastPosition();
            BitSet rs = this._right._lastPosition();
            BitSet bs = new BitSet(Math.max(ls.size(), rs.size()));
            bs.or(rs);
            bs.or(ls);
            return bs;
        }
        return this._right._lastPosition();
    }

    @Override
    void _followPosition(BitSet[] follow, SyntaxNode[] nodes) {
        this._left._followPosition(follow, nodes);
        this._right._followPosition(follow, nodes);
        BitSet leftLast = this._left._lastPosition();
        BitSet rightFirst = this._right._firstPosition();
        int size = leftLast.size();
        while (0 < size--) {
            if (!leftLast.get(size)) continue;
            follow[size].or(rightFirst);
        }
    }

    @Override
    SyntaxNode _clone(int[] pos) {
        CatNode node = new CatNode();
        node._left = this._left._clone(pos);
        node._right = this._right._clone(pos);
        return node;
    }
}

