/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc.datasource;

import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.jdbc.datasource.JDBCDataSourceHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.environment.spring.data.jdbc.runtime.SpringJDBCRuntimeHolder;
import org.anyline.environment.spring.data.transaction.SpringTransactionManage;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.spring.data.datasource.holder.jdbc")
public class SpringJDBCDataSourceHolder
extends JDBCDataSourceHolder {
    private static final SpringJDBCDataSourceHolder instance = new SpringJDBCDataSourceHolder();

    public static SpringJDBCDataSourceHolder instance() {
        return instance;
    }

    public SpringJDBCDataSourceHolder() {
        for (DatabaseType type : DatabaseType.values()) {
            String url = type.url();
            if (!url.contains("jdbc:") || !url.contains("://")) continue;
            DataSourceHolder.register((Object)type, (DataSourceHolder)this);
            DataSourceHolder.register((Object)type.driver(), (DataSourceHolder)this);
            DataSourceHolder.register((Object)type.name().toUpperCase(), (DataSourceHolder)this);
            String[] chks = url.split("://");
            DataSourceHolder.register((Object)chks[0], (DataSourceHolder)this);
        }
        DataSourceHolder.register((Object)"com.alibaba.druid.pool.DruidDataSource", (DataSourceHolder)this);
        DataSourceHolder.register((Object)"com.zaxxer.hikari.HikariDataSource", (DataSourceHolder)this);
        DataSourceHolder.register(Connection.class, (DataSourceHolder)this);
        DataSourceHolder.register(DataSource.class, (DataSourceHolder)this);
        DataSourceHolder.register(JdbcTemplate.class, (DataSourceHolder)this);
    }

    public static DataSource datasource(String key) {
        JdbcTemplate jdbc;
        DataSource datasource = null;
        DataRuntime runtime = RuntimeHolder.runtime((String)key);
        if (null != runtime && null != (jdbc = (JdbcTemplate)runtime.getProcessor())) {
            datasource = jdbc.getDataSource();
        }
        return datasource;
    }

    public static DataSource datasource() {
        return SpringJDBCDataSourceHolder.datasource("default");
    }

    public String runtime(String key, String datasource, boolean override) throws Exception {
        if (null != datasource) {
            Map param;
            DataSourceHolder.check((String)key, (boolean)override);
            this.regTransactionManager(key, datasource);
            DataRuntime runtime = SpringJDBCRuntimeHolder.instance().reg(key, datasource);
            if (null != runtime && null != (param = (Map)params.get(key))) {
                String schema;
                runtime.setDriver(param.get("driver") + "");
                String url = param.get("url") + "";
                runtime.setUrl(url);
                String adapter = param.get("adapter") + "";
                if (BasicUtil.isEmpty((Object)adapter)) {
                    adapter = DataSourceUtil.parseAdapterKey((String)url);
                }
                runtime.setAdapterKey(adapter);
                String catalog = param.get("catalog") + "";
                if (BasicUtil.isEmpty((Object)catalog)) {
                    catalog = DataSourceUtil.parseCatalog((String)url);
                }
                if (ConfigTable.KEEP_ADAPTER == 1) {
                    runtime.setCatalog(catalog);
                }
                if (BasicUtil.isEmpty((Object)(schema = param.get("schema") + ""))) {
                    schema = DataSourceUtil.parseSchema((String)url);
                }
                if (ConfigTable.KEEP_ADAPTER == 1) {
                    runtime.setSchema(schema);
                }
            }
        }
        return datasource;
    }

    public DataRuntime runtime(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        DataRuntime runtime = null;
        if (datasource instanceof DataSource) {
            if (null != ConfigTable.environment) {
                DataSourceHolder.check((String)key, (boolean)override);
                this.regTransactionManager(key, (DataSource)datasource);
                runtime = SpringJDBCRuntimeHolder.instance().reg(key, (DataSource)datasource);
                if (null == adapter && null != type) {
                    adapter = DriverAdapterHolder.getAdapter((DatabaseType)type);
                }
                if (null != adapter) {
                    runtime.setAdapter(adapter);
                }
            } else if (!caches.containsKey(key) || override) {
                caches.put(key, datasource);
            }
        }
        return runtime;
    }

    public void loadCache() {
        for (String key : caches.keySet()) {
            Object datasource = caches.get(key);
            try {
                this.runtime(key, datasource, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean validate(String datasource) throws Exception {
        DataRuntime runtime = RuntimeHolder.runtime((String)datasource);
        return this.validate(runtime);
    }

    public boolean validate(JdbcTemplate jdbc) throws Exception {
        return this.validate(jdbc.getDataSource());
    }

    public boolean validate(DataSource datasource) throws Exception {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection((DataSource)datasource);
        }
        finally {
            if (null != con && !DataSourceUtils.isConnectionTransactional((Connection)con, (DataSource)datasource)) {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
            }
        }
        return true;
    }

    public boolean validate(DataRuntime runtime) throws Exception {
        JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
        return this.validate(jdbc);
    }

    public String regTransactionManager(String key, DataSource datasource, boolean primary) {
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            TransactionManage.reg((String)key, (TransactionManage)new SpringTransactionManage(datasource));
        }
        return key;
    }
}

