/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.interceptor.CountInterceptor;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.interceptor.DeleteInterceptor;
import org.anyline.data.interceptor.ExecuteInterceptor;
import org.anyline.data.interceptor.InsertInterceptor;
import org.anyline.data.interceptor.JDBCInterceptor;
import org.anyline.data.interceptor.QueryInterceptor;
import org.anyline.data.interceptor.UpdateInterceptor;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;

public class InterceptorProxy {
    private static final Map<ACTION.DDL, List<DDInterceptor>> dds = new HashMap<ACTION.DDL, List<DDInterceptor>>();
    private static final List<QueryInterceptor> queryInterceptors = new ArrayList<QueryInterceptor>();
    private static final List<CountInterceptor> countInterceptors = new ArrayList<CountInterceptor>();
    private static final List<UpdateInterceptor> updateInterceptors = new ArrayList<UpdateInterceptor>();
    private static final List<InsertInterceptor> insertInterceptors = new ArrayList<InsertInterceptor>();
    private static final List<DeleteInterceptor> deleteInterceptors = new ArrayList<DeleteInterceptor>();
    private static final List<ExecuteInterceptor> executeInterceptors = new ArrayList<ExecuteInterceptor>();

    public static void setQueryInterceptors(Map<String, QueryInterceptor> interceptors) {
        queryInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(queryInterceptors);
    }

    public static void setCountInterceptors(Map<String, CountInterceptor> interceptors) {
        countInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(countInterceptors);
    }

    public static void setUpdateInterceptors(Map<String, UpdateInterceptor> interceptors) {
        updateInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(updateInterceptors);
    }

    public static void setInsertInterceptors(Map<String, InsertInterceptor> interceptors) {
        insertInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(insertInterceptors);
    }

    public static void setDeleteInterceptors(Map<String, DeleteInterceptor> interceptors) {
        deleteInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(insertInterceptors);
    }

    public static void setExecuteInterceptors(Map<String, ExecuteInterceptor> interceptors) {
        executeInterceptors.addAll(interceptors.values());
        JDBCInterceptor.sort(executeInterceptors);
    }

    public static void setDDInterceptors(Map<String, DDInterceptor> interceptors) {
        for (DDInterceptor dDInterceptor : interceptors.values()) {
            ACTION.DDL action;
            List<ACTION.DDL> actions = dDInterceptor.actions();
            if (null != actions) {
                for (ACTION.DDL action2 : actions) {
                    InterceptorProxy.reg(action2, dDInterceptor);
                }
            }
            if (null == (action = dDInterceptor.action())) continue;
            InterceptorProxy.reg(action, dDInterceptor);
        }
        for (List list : dds.values()) {
            JDBCInterceptor.sort(list);
        }
    }

    public static void reg(ACTION.DDL action, DDInterceptor interceptor) {
        if (action == ACTION.DDL.ALL) {
            for (ACTION.DDL item : ACTION.DDL.values()) {
                if (item == ACTION.DDL.ALL || item == ACTION.DDL.IGNORE) continue;
                InterceptorProxy.reg(item, interceptor);
            }
            return;
        }
        List<DDInterceptor> interceptors = dds.get(action);
        if (null == interceptors) {
            interceptors = new ArrayList<DDInterceptor>();
        }
        dds.put(action, interceptors);
        interceptors.add(interceptor);
    }

    public static ACTION.SWITCH prepareQuery(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.prepare(runtime, random, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareQuery(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.prepare(runtime, random, procedure, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeQuery(DataRuntime runtime, String random, Run run, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.before(runtime, random, run, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeQuery(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.before(runtime, random, procedure, navi);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterQuery(DataRuntime runtime, String random, Run run, boolean exe, Object result, PageNavi navi, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.after(runtime, random, run, exe, result, navi, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterQuery(DataRuntime runtime, String random, Procedure procedure, PageNavi navi, boolean success, Object result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (QueryInterceptor interceptor : queryInterceptors) {
            swt = interceptor.after(runtime, random, procedure, navi, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareCount(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.prepare(runtime, random, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeCount(DataRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.before(runtime, random, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterCount(DataRuntime runtime, String random, Run run, boolean exe, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (CountInterceptor interceptor : countInterceptors) {
            swt = interceptor.after(runtime, random, run, exe, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareUpdate(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.prepare(runtime, random, batch, dest, data, configs, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeUpdate(DataRuntime runtime, String random, Run run, Table dest, Object data, ConfigStore configs, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.before(runtime, random, run, dest, data, configs, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterUpdate(DataRuntime runtime, String random, Run run, Table dest, Object data, ConfigStore configs, List<String> columns, boolean success, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (UpdateInterceptor interceptor : updateInterceptors) {
            swt = interceptor.after(runtime, random, run, dest, data, configs, columns, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareInsert(DataRuntime runtime, String random, int batch, Table dest, Object data, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.prepare(runtime, random, batch, dest, data, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareInsert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.prepare(runtime, random, dest, prepare, configs);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeInsert(DataRuntime runtime, String random, Run run, Table dest, Object data, List<String> columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.before(runtime, random, run, dest, data, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeInsert(DataRuntime runtime, String random, Run run, Table dest, RunPrepare prepare, ConfigStore configs) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.before(runtime, random, run, dest, prepare, configs);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterInsert(DataRuntime runtime, String random, Run run, Table dest, Object data, List<String> columns, boolean success, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.after(runtime, random, run, dest, data, columns, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterInsert(DataRuntime runtime, String random, Run run, Table dest, RunPrepare prepare, ConfigStore configs, boolean success, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (InsertInterceptor interceptor : insertInterceptors) {
            swt = interceptor.after(runtime, random, run, dest, prepare, configs, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(DataRuntime runtime, String random, int batch, Table table, String key, Collection values) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, random, batch, table, key, values);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, random, batch, table, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareDelete(DataRuntime runtime, String random, int batch, Table dest, Object obj, String ... columns) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.prepare(runtime, random, batch, dest, obj, columns);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeDelete(DataRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.before(runtime, random, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterDelete(DataRuntime runtime, String random, Run run, boolean success, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (DeleteInterceptor interceptor : deleteInterceptors) {
            swt = interceptor.after(runtime, random, run, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareExecute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.prepare(runtime, random, prepare, configs, conditions);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH prepareExecute(DataRuntime runtime, String random, Procedure procedure) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.prepare(runtime, random, procedure);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeExecute(DataRuntime runtime, String random, Run run) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.before(runtime, random, run);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH beforeExecute(DataRuntime runtime, String random, Procedure procedure) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.before(runtime, random, procedure);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterExecute(DataRuntime runtime, String random, Run run, boolean success, long result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.after(runtime, random, run, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static ACTION.SWITCH afterExecute(DataRuntime runtime, String random, Procedure procedure, boolean success, boolean result, long millis) {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        for (ExecuteInterceptor interceptor : executeInterceptors) {
            swt = interceptor.after(runtime, random, procedure, success, result, millis);
            if (swt != ACTION.SWITCH.SKIP) continue;
            return swt;
        }
        return swt;
    }

    public static <T extends Metadata<T>> ACTION.SWITCH prepare(DataRuntime runtime, String random, ACTION.DDL action, Metadata<T> metadata) {
        ACTION.SWITCH swt = metadata.swt();
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.prepare(runtime, random, action, metadata);
                metadata.swt(swt);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static <T extends Metadata<T>> ACTION.SWITCH before(DataRuntime runtime, String random, ACTION.DDL action, Metadata<T> metadata, List<Run> runs) {
        ACTION.SWITCH swt = metadata.swt();
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.before(runtime, random, action, metadata, runs);
                metadata.swt(swt);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static <T extends Metadata<T>> ACTION.SWITCH before(DataRuntime runtime, String random, ACTION.DDL action, Metadata<T> metadata, Run run, List<Run> runs) {
        ACTION.SWITCH swt = metadata.swt();
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.before(runtime, random, action, metadata, run, runs);
                metadata.swt(swt);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static <T extends Metadata<T>> ACTION.SWITCH after(DataRuntime runtime, String random, ACTION.DDL action, Metadata<T> metadata, List<Run> runs, boolean result, long millis) {
        ACTION.SWITCH swt = metadata.swt();
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.after(runtime, random, action, metadata, runs, result, millis);
                metadata.swt(swt);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }

    public static <T extends Metadata<T>> ACTION.SWITCH after(DataRuntime runtime, String random, ACTION.DDL action, Metadata<T> metadata, Run run, List<Run> runs, boolean result, long millis) {
        ACTION.SWITCH swt = metadata.swt();
        List<DDInterceptor> interceptors = dds.get(action);
        if (null != interceptors) {
            for (DDInterceptor interceptor : interceptors) {
                swt = interceptor.after(runtime, random, action, metadata, run, runs, result, millis);
                metadata.swt(swt);
                if (swt == ACTION.SWITCH.CONTINUE) continue;
                return swt;
            }
        }
        return swt;
    }
}

