/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SQLStore;
import org.anyline.data.prepare.xml.init.DefaultXMLCondition;
import org.anyline.data.prepare.xml.init.DefaultXMLPrepare;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSQLStore
extends SQLStore {
    private static DefaultSQLStore instance;
    private static Hashtable<String, RunPrepare> sqls;
    private static final Logger log;
    private static String root;
    private static String[] cuts;
    private static long lastLoadTime;

    protected DefaultSQLStore() {
    }

    public static synchronized void loadSQL() {
        String[] dirs;
        root = ConfigTable.SQL_STORE_DIR;
        if (null == root) {
            root = "${classpath}/sql";
        }
        if (root.contains("{classpath}")) {
            root = root.replace("${classpath}", ConfigTable.getClassPath());
            root = root.replace("{classpath}", ConfigTable.getClassPath());
        }
        if (root.contains("{libpath}")) {
            root = root.replace("${libpath}", ConfigTable.getLibPath());
            root = root.replace("{libpath}", ConfigTable.getLibPath());
        }
        root = root.replace("/", FileUtil.getFileSeparator());
        root = root.replace("\\", FileUtil.getFileSeparator());
        root = root.replace("//", FileUtil.getFileSeparator());
        root = root.replace("\\\\", FileUtil.getFileSeparator());
        for (String dir : dirs = root.split(",")) {
            if (dir.startsWith(".")) {
                dir = FileUtil.merge((String[])new String[]{ConfigTable.getRoot(), dir.substring(1)});
            } else if (dir.startsWith("/WEB-INF")) {
                dir = FileUtil.merge((String[])new String[]{ConfigTable.getWebRoot(), dir});
            }
            log.debug("[\u89e3\u6790XML SQL][dir:{}]", (Object)dir);
            DefaultSQLStore.parse(dir);
        }
        lastLoadTime = System.currentTimeMillis();
    }

    private static synchronized void parse(String path) {
        if (path.contains("jar!")) {
            String separator = FileUtil.getFileSeparator();
            Object sub = path.substring(path.indexOf("jar!") + 4).replace("!" + separator, separator) + separator;
            sub = ((String)sub).toLowerCase();
            if (((String)(sub = ((String)sub).replace("!", ""))).startsWith(separator)) {
                sub = ((String)sub).substring(1);
            }
            sub = ((String)sub).replace("\\", "/");
            sub = ((String)sub).replace("//", "/");
            try {
                File file = new File(System.getProperty("java.class.path"));
                DefaultSQLStore.parseJarFile(file, (String)sub);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            DefaultSQLStore.parseFile(new File(path));
        }
    }

    private static synchronized void parseJarFile(File file, String sub) {
        try {
            FileInputStream fin = new FileInputStream(file);
            JarInputStream jis = new JarInputStream(fin);
            ZipEntry entry = null;
            while ((entry = jis.getNextEntry()) != null) {
                String path1 = entry.getName().toLowerCase();
                if (null != sub && !path1.startsWith(sub)) continue;
                if (path1.endsWith(".xml")) {
                    FilterInputStream in = new FilterInputStream(jis){

                        @Override
                        public void close() throws IOException {
                        }
                    };
                    DefaultSQLStore.parseXML(DefaultSQLStore.prefix(null, path1), FileUtil.read((InputStream)in).toString());
                    continue;
                }
                if (!path1.endsWith(".jar")) continue;
                String name1 = FileUtil.getSimpleFileName((String)path1);
                JarInputStream jis2 = new JarInputStream(jis);
                ZipEntry entry2 = null;
                while ((entry2 = jis2.getNextEntry()) != null) {
                    String path2 = entry2.getName();
                    if (!path2.endsWith("xml")) continue;
                    FilterInputStream in2 = new FilterInputStream(jis2){

                        @Override
                        public void close() throws IOException {
                        }
                    };
                    DefaultSQLStore.parseXML(DefaultSQLStore.prefix(name1, path2), FileUtil.read((InputStream)in2).toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized void parseFile(File file) {
        if (null == file) {
            return;
        }
        String name = file.getName().toLowerCase();
        if (file.isDirectory()) {
            File[] files;
            for (File item : files = file.listFiles()) {
                DefaultSQLStore.parseFile(item);
            }
        } else if (name.endsWith(".xml")) {
            String prefix = DefaultSQLStore.prefix(null, file.getPath());
            DefaultSQLStore.parseXML(prefix, FileUtil.read((File)file).toString());
        } else if (name.endsWith(".jar")) {
            DefaultSQLStore.parseJarFile(file, null);
        }
    }

    private static String prefix(String parent, String path) {
        Object result = null;
        String prefix = path;
        if (null != root) {
            String[] dirs;
            String[] stringArray = dirs = root.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String dir = stringArray[i];
                if (!prefix.startsWith(dir)) continue;
                prefix = prefix.replace(dir, "");
            }
        }
        for (String cut : cuts) {
            if (!prefix.contains(cut + "/") && !prefix.contains(cut + "\\")) continue;
            prefix = prefix.substring(prefix.indexOf(cut) + cut.length() + 1);
        }
        if (prefix.contains(".xml")) {
            prefix = prefix.substring(0, prefix.indexOf(".xml"));
        }
        if ((prefix = prefix.replace("/", ".").replace("\\", ".").replace("src/main", ".").replace("src\\main", ".")).startsWith(".")) {
            prefix = prefix.substring(1);
        }
        result = prefix;
        if (null != parent) {
            result = (String)result + "," + parent + "." + prefix;
        }
        return result;
    }

    private static List<RunPrepare> parseMyBatisXML(String prefix, Element root) {
        ArrayList<RunPrepare> result = new ArrayList<RunPrepare>();
        List elements = root.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (!"sql".equalsIgnoreCase(elementName) && !"select".equalsIgnoreCase(elementName) && !"update".equalsIgnoreCase(elementName) && !"insert".equalsIgnoreCase(elementName) && !"delete".equalsIgnoreCase(elementName)) continue;
            String id = element.attributeValue("id");
            String sqlText = element.getText().trim();
            sqlText = RegularUtil.removeTag((String)sqlText, (String[])new String[0]);
            DefaultXMLPrepare prepare = new DefaultXMLPrepare();
            prepare.setText(sqlText);
            prepare.setId(id);
            if (ConfigTable.isSQLDebug()) {
                log.info("[\u89e3\u6790SQL][id:{}]\n[text:{}]", (Object)id, (Object)sqlText);
            }
            result.add(prepare);
        }
        return result;
    }

    private static List<RunPrepare> parseXML(String prefix, Element root) {
        ArrayList<RunPrepare> result = new ArrayList<RunPrepare>();
        HashMap<String, List<Condition>> gloableConditions = new HashMap<String, List<Condition>>();
        Iterator itrCons = root.elementIterator("conditions");
        while (itrCons.hasNext()) {
            Element conditionGroupElement = (Element)itrCons.next();
            String groupId = conditionGroupElement.attributeValue("id");
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            gloableConditions.put(groupId, conditions);
            Iterator itrParam = conditionGroupElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                conditions.add(DefaultSQLStore.parseCondition(null, null, (Element)itrParam.next()));
            }
        }
        Iterator itrSql = root.elementIterator("sql");
        while (itrSql.hasNext()) {
            Element sqlElement = (Element)itrSql.next();
            String id = sqlElement.attributeValue("id");
            boolean strict = BasicUtil.parseBoolean((Object)sqlElement.attributeValue("strict"), (Boolean)false);
            String sqlText = sqlElement.elementText("text").trim();
            DefaultXMLPrepare prepare = new DefaultXMLPrepare();
            prepare.setText(sqlText);
            prepare.setStrict(strict);
            Iterator itrParam = sqlElement.elementIterator("condition");
            while (itrParam.hasNext()) {
                DefaultSQLStore.parseCondition(prepare, gloableConditions, (Element)itrParam.next());
            }
            String group = sqlElement.elementText("group");
            String order = sqlElement.elementText("order");
            prepare.group(group);
            prepare.order(order);
            prepare.setId(id);
            if (ConfigTable.isSQLDebug()) {
                log.debug("[\u89e3\u6790SQL][id:{}]\n[text:{}]", (Object)id, (Object)sqlText);
            }
            result.add(prepare);
        }
        return result;
    }

    private static void parseXML(String prefix, String content) {
        List<Object> prepares = new ArrayList();
        Document document = DefaultSQLStore.createDocument(content);
        if (null == document) {
            return;
        }
        Element root = document.getRootElement();
        String rootName = root.getName();
        prepares = "mapper".equalsIgnoreCase(rootName) ? DefaultSQLStore.parseMyBatisXML(prefix, root) : DefaultSQLStore.parseXML(prefix, root);
        for (RunPrepare runPrepare : prepares) {
            String[] prefixs;
            for (String _prefix : prefixs = prefix.split(",")) {
                String sqlId = _prefix + ":" + runPrepare.getId();
                runPrepare.setDest(sqlId);
                if (sqls.containsKey(sqlId)) {
                    sqls.get(sqlId).setMultiple(true);
                    log.warn("[SQL Prepare \u91cd\u540d][\u8c03\u7528\u65f6\u8bf7\u6ce8\u610f\u6dfb\u52a0\u524d\u7f00][id:{}]", (Object)sqlId);
                    continue;
                }
                sqls.put(sqlId, runPrepare);
                log.debug("[\u521b\u5efaSQL Prepare][id:{}]", (Object)sqlId);
            }
        }
    }

    private static Condition parseCondition(RunPrepare prepare, Map<String, List<Condition>> map, Element element) {
        Condition condition = null;
        String id = element.attributeValue("id");
        Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        String _swt = element.attributeValue("switch");
        if (BasicUtil.isNotEmpty((Object)_swt)) {
            swt = Compare.EMPTY_VALUE_SWITCH.valueOf((String)_swt.toUpperCase());
        } else {
            boolean required = BasicUtil.parseBoolean((Object)element.attributeValue("required"), (Boolean)false);
            boolean strictRequired = BasicUtil.parseBoolean((Object)element.attributeValue("strictRequired"), (Boolean)false);
            if (strictRequired) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
            } else if (required) {
                swt = Compare.EMPTY_VALUE_SWITCH.NULL;
            }
        }
        if (null != id) {
            boolean isStatic = BasicUtil.parseBoolean((Object)element.attributeValue("static"), (Boolean)false);
            Object text = element.getText().trim();
            if (!((String)text).toUpperCase().startsWith("AND ")) {
                text = "\nAND " + (String)text;
            }
            condition = new DefaultXMLCondition(id, (String)text, isStatic);
            String test = element.attributeValue("test");
            condition.setTest(test);
            if (null != prepare) {
                prepare.addCondition(condition);
            }
        } else {
            List<Condition> conditions;
            String ref = element.attributeValue("ref");
            if (null != ref && null != prepare && null != map && null != (conditions = map.get(ref))) {
                for (Condition c : conditions) {
                    prepare.addCondition(c);
                }
            }
        }
        if (null != condition) {
            condition.setSwt(swt);
        }
        return condition;
    }

    private static Document createDocument(File file) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static Document createDocument(InputStream is) {
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            document = reader.read(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static Document createDocument(String content) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public static synchronized DefaultSQLStore getInstance() {
        if (instance == null) {
            instance = new DefaultSQLStore();
        }
        return instance;
    }

    public static RunPrepare parseSQL(String id) {
        RunPrepare prepare = null;
        if (ConfigTable.getReload() > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)ConfigTable.getReload()) {
            DefaultSQLStore.loadSQL();
        }
        try {
            if (ConfigTable.isSQLDebug()) {
                log.debug("[\u63d0\u53d6SQL][id:{}]", (Object)id);
            }
            log.debug("sqlId:{}", (Object)id);
            prepare = sqls.get(id);
            if (null == prepare) {
                log.error("[SQL\u63d0\u53d6\u5931\u8d25][id:{}][\u6240\u6709\u53ef\u7528sql:{}]", (Object)id, (Object)BeanUtil.concat((Collection)BeanUtil.getMapKeys(sqls)));
            } else if (prepare.isMultiple()) {
                log.error("[SQL\u63d0\u53d6\u5931\u8d25][\u6709\u591a\u4e2a\u91cd\u540dSQL\u4f7f\u7528\u5b8c\u6574ID\u8c03\u7528][id:{}]", (Object)id);
            }
        }
        catch (Exception e) {
            log.error("[SQL\u63d0\u53d6\u5931\u8d25][id:{}]", (Object)id);
        }
        return prepare;
    }

    static {
        sqls = new Hashtable();
        log = LoggerFactory.getLogger(DefaultSQLStore.class);
        cuts = "sql,classes".split(",");
        lastLoadTime = 0L;
        DefaultSQLStore.loadSQL();
    }
}

