/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.anyline.data.prepare.Group;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.init.AbstractGroup;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class DefaultGroupStore
implements GroupStore,
Serializable {
    private static final long serialVersionUID = 1257282062069295247L;
    private List<Group> groups = new ArrayList<Group>();

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    @Override
    public void group(Group group) {
        if (null == group) {
            return;
        }
        Group tmp = this.getGroup(group.getColumn());
        if (null == tmp) {
            this.groups.add(group);
        }
    }

    @Override
    public void group(String str) {
        String[] tmps;
        if (BasicUtil.isEmpty((Object)str)) {
            return;
        }
        if (str.toUpperCase().contains("GROUP BY")) {
            str = str.toUpperCase().replace("GROUP BY", "").trim();
        }
        for (String tmp : tmps = str.split(",")) {
            this.group(new AbstractGroup(tmp));
        }
    }

    @Override
    public Group getGroup(String group) {
        if (null == group) {
            return null;
        }
        if (null != this.groups) {
            for (Group o : this.groups) {
                if (null == o || !group.equalsIgnoreCase(o.getColumn())) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.groups.clear();
    }

    @Override
    public String getRunText(String delimiter) {
        StringBuilder builder = new StringBuilder();
        if (null != this.groups && !this.groups.isEmpty()) {
            builder.append(" GROUP BY ");
            for (int i = 0; i < this.groups.size(); ++i) {
                Group group = this.groups.get(i);
                if (null == group) continue;
                SQLUtil.delimiter((StringBuilder)builder, (String)group.getColumn(), (String)delimiter);
                if (i >= this.groups.size() - 1) continue;
                builder.append(",");
            }
        }
        return builder.toString();
    }

    @Override
    public boolean isEmpty() {
        if (null != this.groups) {
            return this.groups.isEmpty();
        }
        return true;
    }

    @Override
    public GroupStore clone() {
        DefaultGroupStore clone = null;
        try {
            clone = (DefaultGroupStore)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultGroupStore();
        }
        if (null != this.groups) {
            for (Group group : this.groups) {
                clone.group(group.clone());
            }
        }
        return clone;
    }
}

