/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.util.HashMap;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.metadata.type.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReaderFactory {
    private static final Logger log = LoggerFactory.getLogger(DataReaderFactory.class);
    protected static Map<DatabaseType, Map<Object, DataReader>> readers = new HashMap<DatabaseType, Map<Object, DataReader>>();

    public static void reg(DatabaseType dbt, Object[] supports, DataReader reader) {
        Map<Object, DataReader> map;
        if (null == supports) {
            supports = reader.supports();
        }
        if (null == supports) {
            log.warn("[DataReader \u672a\u58f0\u660e\u652f\u6301\u7c7b\u578b][cass:{}]", (Object)reader.getClass().getName());
            return;
        }
        if (null == dbt) {
            dbt = DatabaseType.NONE;
        }
        if (null == (map = readers.get(dbt))) {
            map = new HashMap<Object, DataReader>();
            readers.put(dbt, map);
        }
        for (Object support : supports) {
            if (support instanceof String) {
                support = ((String)support).toUpperCase();
            }
            map.put(support, reader);
        }
    }

    public static void reg(DatabaseType dbt, DataReader reader) {
        DataReaderFactory.reg(dbt, null, reader);
    }

    public static void reg(Object[] supports, DataReader reader) {
        DataReaderFactory.reg(DatabaseType.NONE, supports, reader);
    }

    public static void reg(DataReader reader) {
        DataReaderFactory.reg(DatabaseType.NONE, null, reader);
    }

    public static DataReader reader(DatabaseType dbt, Object type) {
        Map<Object, DataReader> map;
        if (null == dbt) {
            dbt = DatabaseType.NONE;
        }
        if (type instanceof String) {
            type = ((String)type).toUpperCase();
        }
        if (null != (map = readers.get(dbt))) {
            return map.get(type);
        }
        return null;
    }
}

