/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.run.AbstractRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;

public class TextRun
extends AbstractRun
implements Run {
    private String text;

    public TextRun() {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orderStore = new DefaultOrderStore();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.parseText();
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        this.parseText();
        return this;
    }

    @Override
    public void init() {
        List<Condition> conditions;
        super.init();
        if (null != this.conditionChain && null != (conditions = this.conditionChain.getConditions())) {
            for (Condition condition : conditions) {
                if (null == condition) continue;
                AutoCondition con = (AutoCondition)condition;
                List<Variable> vars = this.getVariables(con.getId());
                if (!vars.isEmpty()) {
                    con.setVariableSlave(true);
                    for (Variable var : vars) {
                        var.setValue(false, con.getValues());
                    }
                    continue;
                }
                this.setConditionValue(con.getSwt(), con.getCompare(), con.getId(), null, con.getValues());
            }
        }
        if (null != this.configs) {
            PageNavi navi;
            List orders;
            OrderStore orderStore;
            List<Config> confs = this.configs.getConfigChain().getConfigs();
            for (Config conf : confs) {
                boolean overCondition = conf.isOverCondition();
                boolean overValue = conf.isOverValue();
                List<Object> values = conf.getValues();
                Compare compare = conf.getCompare();
                String varKey = conf.getVariable();
                List<Variable> vars = this.getVariables(varKey);
                boolean isUse = false;
                if (overCondition) {
                    List<Condition> cons = this.getConditions(varKey);
                    for (Condition con : cons) {
                        boolean isConVarSetValue;
                        if (null == con) continue;
                        boolean bl = isConVarSetValue = con.isSetValue() || con.isSetValue(varKey);
                        if (isConVarSetValue && !overValue) continue;
                        isUse = true;
                        con.setVariableSlave(true);
                        this.setConditionValue(conf.getSwt(), conf.getCompare(), varKey, varKey, values);
                    }
                }
                for (Variable var : vars) {
                    if (!overValue && var.isSetValue()) continue;
                    isUse = true;
                    var.setValue(false, values);
                }
                if (compare == Compare.NONE || isUse) continue;
                this.conditionChain.addCondition(conf.createAutoCondition(this.conditionChain));
            }
            List<Object> values = this.configs.values();
            if (null != values) {
                int i = 0;
                int len = values.size();
                for (Variable var : this.variables) {
                    if (i >= len) break;
                    var.setValue(values.get(i));
                    ++i;
                }
            }
            if (null != (orderStore = this.configs.getOrders()) && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.addOrder(order);
                }
            }
            if ((navi = this.configs.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
    }

    private void parseText() {
    }

    @Override
    public boolean checkValid() {
        if (!this.valid) {
            return false;
        }
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
        if (null != this.configs && !this.configs.isValid()) {
            this.valid = false;
        }
        return this.valid;
    }

    public void appendGroup() {
        if (null != this.configs) {
            if (null == this.groupStore) {
                this.groupStore = this.configs.getGroups();
            }
            if (BasicUtil.isEmpty((Object)this.having)) {
                this.having = this.configs.getHaving();
            }
        }
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
        if (BasicUtil.isNotEmpty((Object)this.having)) {
            if (this.having.trim().toUpperCase().startsWith("HAVING")) {
                this.builder.append(this.having);
            } else {
                this.builder.append(" HAVING ").append(this.having);
            }
        }
    }

    public void appendCondition(boolean placeholder) {
        if (null == this.conditionChain) {
            return;
        }
        List<Condition> cons = this.conditionChain.getConditions();
        if (null == cons || cons.size() == 0) {
            return;
        }
        String txt = this.builder.toString();
        String condition = this.conditionChain.getRunText(null, this.runtime, placeholder);
        if (!condition.isEmpty()) {
            this.emptyCondition = false;
        }
        boolean where = TextRun.endWithWhere(txt);
        if (!this.emptyCondition) {
            if (!where) {
                this.builder.append("\nWHERE ");
                condition = condition.trim();
                String up = condition.toUpperCase();
                if (up.startsWith("AND ") || up.startsWith("AND(")) {
                    condition = condition.substring(3);
                } else if (up.startsWith("OR ") || up.startsWith("OR(")) {
                    condition = condition.substring(2);
                }
            }
            this.builder.append(condition);
        }
        if (where) {
            this.emptyCondition = false;
        }
        this.addValues(this.conditionChain.getRunValues());
    }

    public void setConfigs(ConfigStore configs) {
        this.configs = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    public TextRun addValues(String key, Object obj) {
        if (null == obj) {
            return this;
        }
        if (null == this.values) {
            this.values = new ArrayList();
        }
        if (null != obj && obj instanceof RunValue) {
            throw new RuntimeException("run value");
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object item : list) {
                this.addValues(key, item);
            }
        } else {
            this.addValues(new RunValue(key, obj));
        }
        return this;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    public Run addCondition(String condition, String variable, Object value) {
        if (null != this.variables && BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (null == v || !v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        Condition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    @Override
    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, prefix, var, value);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        this.conditionChain.addCondition(condition);
        return this;
    }

    @Override
    public Variable getVariable(String key) {
        if (null == key || null == this.variables) {
            return null;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            return var;
        }
        return null;
    }

    public List<Variable> getVariables(String key) {
        ArrayList<Variable> list = new ArrayList<Variable>();
        if (null == key || null == this.variables) {
            return list;
        }
        for (Variable var : this.variables) {
            if (null == var || !key.equalsIgnoreCase(var.getKey())) continue;
            list.add(var);
        }
        return list;
    }
}

