/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.List;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.ParseResult;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.param.init.DefaultConfigChain;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.PageNavi;
import org.anyline.entity.PageNaviConfig;
import org.anyline.util.BasicUtil;

public class ConfigBuilder {
    public static ConfigStore build(String json) {
        DataRow row = DataRow.parseJson((KeyAdapter.KEY_CASE)KeyAdapter.KEY_CASE.UPPER, (String)json);
        ConfigStore configs = ConfigBuilder.parse(row);
        return configs;
    }

    public static ConfigStore parse(DataRow row) {
        DataRow navi;
        DataRow columns;
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        DataRow conditions = row.getRow("conditions");
        if (null != conditions) {
            ConfigChain chain = ConfigBuilder.parseConfigChain(conditions);
            configs.setChain(chain);
        }
        if (null != (columns = row.getRow("columns"))) {
            List query = columns.getList("query");
            configs.columns(query);
            List excludes = columns.getList("exclude");
            configs.excludes(excludes);
        }
        if (null != (navi = row.getRow("navi"))) {
            configs.setPageNavi(ConfigBuilder.parseNavi(navi));
        }
        return configs;
    }

    public static PageNavi parseNavi(DataRow row) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setCurPage((long)row.getInt("page", Integer.valueOf(1)).intValue());
        navi.setPageRows(row.getInt("vol", Integer.valueOf(PageNaviConfig.DEFAULT_VAR_PAGE_DEFAULT_VOL)).intValue());
        navi.setTotalRow((long)row.getInt("total", Integer.valueOf(0)).intValue());
        navi.autoCount(row.getBoolean("auto_count", PageNaviConfig.IS_AUTO_COUNT).booleanValue());
        return navi;
    }

    public static Config parseConfig(DataRow row) {
        Config config = null;
        DataSet items = row.getSet("items");
        if (null != items && !items.isEmpty()) {
            config = ConfigBuilder.parseConfigChain(row);
        } else {
            ParseResult parser = new ParseResult();
            parser.setVar(row.getString("var"));
            DataRow parse = row.getRow("parser");
            if (null != parse) {
                parser.setPrefix(parse.getString("prefix"));
                parser.setVar(parse.getString("var"));
                parser.setClazz(parse.getString("class"));
                parser.setMethod(parse.getString("method"));
                parser.setKey(parse.getString("key"));
                parser.setJoin(parse.getString("join"));
                parser.setCompare(ConfigBuilder.compare(parse.getInt("compare", Integer.valueOf(Compare.EQUAL.getCode()))));
                String swt = parse.getString("swt");
                if (BasicUtil.isNotEmpty((Object)swt)) {
                    try {
                        parser.setSwt(Compare.EMPTY_VALUE_SWITCH.valueOf((String)swt));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            config = new DefaultConfig(parser);
            config.setJoin(row.getString("join"));
            config.setText(row.getString("text"));
            config.setKey(row.getString("key"));
            config.setValue(row.get("values"));
            config.setOverCondition(row.getBoolean("over_condition", Boolean.valueOf(false)));
            config.setOverValue(row.getBoolean("over_value", Boolean.valueOf(true)));
            config.setCompare(ConfigBuilder.compare(row.getInt("compare", Integer.valueOf(Compare.EQUAL.getCode()))));
        }
        return config;
    }

    public static ConfigChain parseConfigChain(DataRow row) {
        DefaultConfigChain chain = null;
        chain = new DefaultConfigChain();
        chain.setJoin(row.getString("join"));
        chain.setText(row.getString("text"));
        DataSet items = row.getSet("items");
        if (null != items) {
            for (DataRow item : items) {
                Config config = ConfigBuilder.parseConfig(item);
                if (null == config) continue;
                chain.addConfig(config);
            }
        }
        return chain;
    }

    public static Compare compare(int code) {
        for (Compare compare : Compare.values()) {
            if (compare.getCode() != code) continue;
            return compare;
        }
        return Compare.EQUAL;
    }
}

