/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.transaction;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.anyline.data.transaction.TransactionDefine;
import org.anyline.data.transaction.TransactionState;
import org.anyline.data.transaction.init.DefaultTransactionDefine;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;

public interface TransactionManage {
    public static final Log log = LogProxy.get(TransactionManage.class);
    public static final Map<TransactionState, TransactionManage> records = new Hashtable<TransactionState, TransactionManage>();
    public static final Map<String, TransactionManage> instances = new Hashtable<String, TransactionManage>();

    public static void reg(String datasource, TransactionManage instance) {
        instances.put(datasource, instance);
    }

    public static TransactionManage instance(TransactionState state) {
        return records.get(state);
    }

    public static TransactionManage instance(String datasource) {
        return instances.get(datasource);
    }

    public TransactionState start(TransactionDefine var1) throws SQLException;

    default public TransactionState start(int behavior) throws SQLException {
        DefaultTransactionDefine define = new DefaultTransactionDefine(behavior);
        return this.start(define);
    }

    default public TransactionState start() throws SQLException {
        return this.start(0);
    }

    public void commit(TransactionState var1) throws SQLException;

    public void rollback(TransactionState var1) throws SQLException;
}

