/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.List;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.init.AbstractConditionChain;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.RegularUtil;

public class DefaultXMLConditionChain
extends AbstractConditionChain
implements ConditionChain {
    @Override
    public String getRunText(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        this.initRunValue();
        StringBuilder builder = new StringBuilder();
        if (null != this.conditions) {
            for (Condition condition : this.conditions) {
                if (null == condition) continue;
                String txt = "";
                if (condition.getVariableType() == 2) {
                    txt = condition.getRunText(prefix, runtime, placeholder, unicode);
                } else if (condition.isActive()) {
                    txt = condition.getRunText(prefix, runtime, placeholder, unicode);
                    List<RunValue> values = condition.getRunValues();
                    if (BasicUtil.isEmpty((boolean)true, values)) {
                        String reg = "=\\s*\\?";
                        if (RegularUtil.match((String)txt, (String)reg)) {
                            txt = txt.replaceAll(reg, " IS NULL ");
                        }
                    } else {
                        this.addRunValue(values);
                    }
                }
                if (BasicUtil.isNotEmpty((Object)txt) && condition instanceof AutoCondition) {
                    txt = condition.getJoinText() + txt;
                }
                if (!condition.isActive()) continue;
                builder.append("\n\t");
                builder.append(txt.trim());
            }
        }
        return builder.toString();
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void setValue(String name, Object value) {
        if (null != this.conditions) {
            for (Condition con : this.conditions) {
                if (null == con || !con.getId().equalsIgnoreCase(name)) continue;
                con.setValue(name, value);
                break;
            }
        }
    }
}

