/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.entity.Join;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.VariableBlock;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultGroupStore;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Group;
import org.anyline.entity.GroupStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;

public abstract class AbstractRun
implements Run {
    protected static final Log log = LogProxy.get(AbstractRun.class);
    protected StringBuilder builder = new StringBuilder();
    protected int batch;
    protected int vol;
    protected RunPrepare prepare;
    protected Catalog catalog;
    protected Schema schema;
    protected Table table;
    protected String text;
    protected List<String> keys;
    protected List<RunValue> values = new ArrayList<RunValue>();
    protected List<RunValue> batchValues;
    protected PageNavi pageNavi;
    protected ConditionChain conditionChain;
    protected ConfigStore configs;
    protected OrderStore orderStore;
    protected GroupStore groupStore;
    protected String having;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<VariableBlock> blocks = new ArrayList<VariableBlock>();
    protected Object value;
    protected TypeMetadata valueType;
    protected Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
    protected boolean valid = true;
    protected LinkedHashMap<String, Column> insertColumns = null;
    protected LinkedHashMap<String, Column> updateColumns;
    protected List<String> queryColumns;
    protected List<String> excludeColumn;
    protected Object from;
    protected int getOriginType = 1;
    protected long rows = -1L;
    protected boolean supportBr = true;
    protected DataRuntime runtime;
    protected String delimiterFr;
    protected String delimiterTo;
    protected ACTION action;
    protected boolean emptyCondition = true;
    protected String distinct = "";
    protected String alias;
    protected List<Join> joins = new ArrayList<Join>();
    protected boolean unionAll = false;
    protected List<Run> unions = new ArrayList<Run>();
    protected boolean slice = false;

    @Override
    public boolean isEmptyCondition() {
        return this.emptyCondition && (null == this.values || this.values.isEmpty());
    }

    @Override
    public DriverAdapter adapter() {
        if (null != this.runtime) {
            return this.runtime.getAdapter();
        }
        return null;
    }

    @Override
    public Run setRuntime(DataRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return null == this.builder || this.builder.length() <= 0;
    }

    public void slice(boolean slice) {
        this.slice = slice;
    }

    public boolean slice() {
        return this.slice;
    }

    @Override
    public long getRows() {
        return this.rows;
    }

    @Override
    public Run setRows(long rows) {
        this.rows = rows;
        return this;
    }

    @Override
    public int getOriginType() {
        return this.getOriginType;
    }

    @Override
    public void setOriginType(int type) {
        this.getOriginType = type;
    }

    @Override
    public void init() {
        if (null != this.runtime) {
            this.delimiterFr = this.runtime.getAdapter().getDelimiterFr();
            this.delimiterTo = this.runtime.getAdapter().getDelimiterTo();
        }
        if (null != this.configs) {
            this.setPageNavi(this.configs.getPageNavi());
        }
    }

    public String getText() {
        return this.text;
    }

    public Run setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = BasicUtil.isNotEmpty((Object)catalog) ? new Catalog(catalog) : null;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setSchema(String schema) {
        this.schema = BasicUtil.isNotEmpty((Object)schema) ? new Schema(schema) : null;
    }

    public void setTable(String table) {
        this.table = BasicUtil.isNotEmpty((Object)table) ? new Table(table) : null;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public String getDest() {
        String dest = null;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        String tableName = this.getTableName();
        if (BasicUtil.isNotEmpty((Object)catalogName)) {
            dest = catalogName;
        }
        if (BasicUtil.isNotEmpty((Object)schemaName)) {
            dest = null == dest ? schemaName : dest + "." + schemaName;
        }
        if (BasicUtil.isNotEmpty((Object)tableName)) {
            dest = null == dest ? tableName : dest + "." + tableName;
        }
        return dest;
    }

    @Override
    public Run group(String group) {
        if (BasicUtil.isEmpty((Object)group)) {
            return this;
        }
        if (null == this.groupStore) {
            this.groupStore = new DefaultGroupStore();
        }
        group = group.trim().toUpperCase();
        if (!this.groupStore.getGroups().contains(group)) {
            this.groupStore.group(group);
        }
        return this;
    }

    @Override
    public Run order(String order) {
        if (null == this.orderStore) {
            this.orderStore = new DefaultOrderStore();
        }
        this.orderStore.order(order);
        return this;
    }

    @Override
    public RunPrepare getPrepare() {
        return this.prepare;
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        String having;
        OrderStore orders;
        this.prepare = prepare;
        this.table = prepare.getTable();
        GroupStore groups = prepare.getGroups();
        if (null != groups) {
            this.setGroupStore(groups);
        }
        if (null != (orders = prepare.getOrders())) {
            this.setOrderStore(orders);
        }
        if (null != (having = prepare.getHaving())) {
            this.having = having;
        }
        this.setText(prepare.getText());
        return this;
    }

    @Override
    public List<RunValue> getRunValues() {
        if (null != this.batchValues) {
            return this.batchValues;
        }
        return this.values;
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> list;
        block3: {
            block2: {
                list = new ArrayList<Object>();
                if (null == this.batchValues) break block2;
                for (RunValue value : this.batchValues) {
                    list.add(value.getValue());
                }
                break block3;
            }
            if (null == this.values) break block3;
            for (RunValue value : this.values) {
                list.add(value.getValue());
            }
        }
        return list;
    }

    @Override
    public void setValues(String key, Collection<Object> values) {
        this.values = new ArrayList<RunValue>();
        this.addValues(key, values);
    }

    @Override
    public void addValues(String key, Collection<Object> values) {
        if (null != values) {
            if (null == this.values) {
                this.values = new ArrayList<RunValue>();
            }
            for (Object value : values) {
                this.values.add(new RunValue(key, value, null));
            }
        }
    }

    @Override
    public List<RunValue> addValues(Compare compare, Column column, Object obj, boolean split) {
        ArrayList<RunValue> rvs = new ArrayList<RunValue>();
        if (null != obj && split && (null == column || !column.isArray()) && this.getOriginType() != 2) {
            String type;
            boolean json = false;
            if (null != column && null != (type = column.getTypeName()) && (type.toUpperCase().contains("JSON") || type.toUpperCase().contains("BSON"))) {
                json = true;
            }
            if (!json) {
                if (obj.getClass().isArray()) {
                    if (obj instanceof byte[] || obj instanceof Byte[]) {
                        RunValue rv = new RunValue(column, obj);
                        rvs.add(rv);
                        this.addValues(rv);
                    } else {
                        int len = Array.getLength(obj);
                        for (int i = 0; i < len; ++i) {
                            Object v = Array.get(obj, i);
                            RunValue rv = new RunValue(column, v);
                            rvs.add(rv);
                            this.addValues(rv);
                            if (Compare.EQUAL == compare) break;
                        }
                        if (len == 0) {
                            RunValue rv = new RunValue(column, null);
                            this.addValues(rv);
                            rvs.add(rv);
                        }
                    }
                } else if (obj instanceof Collection && !json) {
                    Collection list = (Collection)obj;
                    for (Object item : list) {
                        RunValue rv = new RunValue(column, item);
                        this.addValues(rv);
                        rvs.add(rv);
                        if (Compare.EQUAL != compare) continue;
                        break;
                    }
                    if (list.isEmpty()) {
                        RunValue rv = new RunValue(column, null);
                        this.addValues(rv);
                        rvs.add(rv);
                    }
                }
            }
        }
        if (rvs.isEmpty()) {
            RunValue rv = new RunValue(column, obj);
            this.addValues(rv);
            rvs.add(rv);
        }
        return rvs;
    }

    public Run addValues(RunValue run) {
        if (null == this.values) {
            this.values = new ArrayList<RunValue>();
        }
        this.values.add(run);
        if (null != this.values && !this.values.isEmpty()) {
            this.emptyCondition = false;
        }
        return this;
    }

    public Run addValues(List<RunValue> values) {
        for (RunValue value : values) {
            this.addValues(value);
        }
        if (null != this.values && !this.values.isEmpty()) {
            this.emptyCondition = false;
        }
        return this;
    }

    public Run setRunValues(List<RunValue> values) {
        this.values = values;
        if (null != values && !values.isEmpty()) {
            this.emptyCondition = false;
        }
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.pageNavi;
    }

    @Override
    public void setPageNavi(PageNavi pageNavi) {
        this.pageNavi = pageNavi;
    }

    @Override
    public ConfigStore getConfigs() {
        return this.configs;
    }

    @Override
    public void setConfigStore(ConfigStore configs) {
        this.configs = configs;
        if (null != configs) {
            OrderStore orders;
            String having;
            GroupStore groups = configs.getGroups();
            if (null != groups) {
                if (this.groupStore == null) {
                    this.groupStore = new DefaultGroupStore();
                }
                List list = groups.getGroups();
                for (Group group : list) {
                    this.groupStore.group(group);
                }
            }
            if (BasicUtil.isNotEmpty((Object)(having = configs.getHaving()))) {
                this.having = having;
            }
            if (null != (orders = configs.getOrders())) {
                this.orderStore = orders;
            }
        }
    }

    @Override
    public void addConfigStore(ConfigStore configs) {
        if (null == this.configs) {
            this.configs = configs;
        } else if (null != configs) {
            OrderStore orders;
            PageNavi navi;
            String having;
            this.configs.and(configs);
            GroupStore groups = configs.getGroups();
            if (null != groups) {
                if (this.groupStore == null) {
                    this.groupStore = new DefaultGroupStore();
                }
                List list = groups.getGroups();
                for (Group group : list) {
                    this.groupStore.group(group);
                }
                this.configs.setGroups(this.groupStore);
            }
            if (BasicUtil.isNotEmpty((Object)(having = configs.getHaving()))) {
                this.having = having;
                this.configs.having(having);
            }
            if (null != (navi = configs.getPageNavi())) {
                this.pageNavi = navi;
                this.configs.setPageNavi(navi);
            }
            if (null != (orders = configs.getOrders())) {
                this.orderStore = orders;
                this.configs.setOrders(orders);
            }
        }
    }

    @Override
    public OrderStore getOrderStore() {
        return this.orderStore;
    }

    @Override
    public void setOrderStore(OrderStore orderStore) {
        this.orderStore = orderStore;
    }

    @Override
    public GroupStore getGroupStore() {
        return this.groupStore;
    }

    @Override
    public void setGroupStore(GroupStore groupStore) {
        this.groupStore = groupStore;
    }

    @Override
    public void setHaving(String having) {
        this.having = having;
    }

    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    public void setDelimiterFr(String delimiterFr) {
        this.delimiterFr = delimiterFr;
    }

    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public void setDelimiterTo(String delimiterTo) {
        this.delimiterTo = delimiterTo;
    }

    public DriverAdapter getAdapter() {
        return this.runtime.getAdapter();
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String variable, Object value) {
        return this;
    }

    @Override
    public void setOrders(String ... orders) {
        if (null != orders) {
            for (String order : orders) {
                this.order(order);
            }
        }
    }

    @Override
    public String getFinalQuery(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalQuery(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    @Override
    public String getTotalQuery(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalTotal(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    @Override
    public String getFinalExists(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalExists(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    @Override
    public String getBaseQuery(boolean placeholder) {
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    @Override
    public Run addValue(RunValue value) {
        if (null == this.values) {
            this.values = new ArrayList<RunValue>();
        }
        this.values.add(value);
        return this;
    }

    @Override
    public Run setConditionChain(ConditionChain chain) {
        this.conditionChain = chain;
        return this;
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.conditionChain;
    }

    @Override
    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, String datatype) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, prefix, var, value);
        condition.datatype(datatype);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        if (condition.isActive()) {
            this.conditionChain.addCondition(condition);
        } else if (swt == Compare.EMPTY_VALUE_SWITCH.BREAK) {
            this.conditionChain.setValid(false);
        }
        return this;
    }

    @Override
    public Run addCondition(Condition condition) {
        if (null != this.conditionChain) {
            this.conditionChain.addCondition(condition);
        }
        return this;
    }

    @Override
    public Condition getCondition(String name) {
        for (Condition con : this.conditionChain.getConditions()) {
            if (null == con || null == con.getId() || !con.getId().equalsIgnoreCase(name)) continue;
            return con;
        }
        return null;
    }

    @Override
    public List<Condition> getConditions(String name) {
        ArrayList<Condition> list = new ArrayList<Condition>();
        for (Condition con : this.conditionChain.getConditions()) {
            if (null == con || null == con.getId() || !con.getId().equalsIgnoreCase(name)) continue;
            list.add(con);
        }
        return list;
    }

    @Override
    public String getFinalDelete(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    @Override
    public String getFinalInsert(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    @Override
    public String getFinalUpdate(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        return text;
    }

    public Run addVariable(Variable var) {
        this.variables.add(var);
        return this;
    }

    public Run addVariable(List<Variable> vars) {
        this.variables.addAll(vars);
        return this;
    }

    public Run addVariableBlock(VariableBlock block) {
        this.blocks.add(block);
        return this;
    }

    @Override
    public String getFinalExecute(boolean placeholder) {
        String text = this.builder.toString();
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        text = this.format(text);
        if (!this.supportBr()) {
            text = text.replace("\r\n", " ").replace("\n", " ");
        }
        return text;
    }

    @Override
    public boolean supportBr() {
        return this.supportBr;
    }

    @Override
    public void supportBr(boolean support) {
        this.supportBr = support;
    }

    @Override
    public Compare.EMPTY_VALUE_SWITCH getStrict() {
        return this.swt;
    }

    @Override
    public void setSwt(Compare.EMPTY_VALUE_SWITCH swt) {
        this.swt = swt;
    }

    @Override
    public boolean isValid() {
        if (!this.valid) {
            return false;
        }
        this.valid = this.checkValid();
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public LinkedHashMap<String, Column> getInsertColumns(boolean metadata) {
        return this.insertColumns;
    }

    @Override
    public List<String> getInsertColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        if (null != this.insertColumns) {
            for (Column column : this.insertColumns.values()) {
                keys.add(column.getName());
            }
        }
        return keys;
    }

    @Override
    public Run setInsertColumns(List<String> columns) {
        if (null != columns) {
            if (null == this.insertColumns) {
                this.insertColumns = new LinkedHashMap();
            }
            for (String column : columns) {
                this.insertColumns.put(column.toUpperCase(), new Column(column));
            }
        }
        return this;
    }

    @Override
    public Run setInsertColumns(LinkedHashMap<String, Column> columns) {
        this.insertColumns = columns;
        return this;
    }

    @Override
    public LinkedHashMap<String, Column> getUpdateColumns(boolean metadata) {
        return this.updateColumns;
    }

    @Override
    public List<String> getUpdateColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        if (null != this.updateColumns) {
            for (Column column : this.updateColumns.values()) {
                keys.add(column.getName());
            }
        }
        return keys;
    }

    @Override
    public Run setUpdateColumns(List<String> columns) {
        if (null != columns) {
            if (null == this.updateColumns) {
                this.updateColumns = new LinkedHashMap();
            }
            for (String column : columns) {
                this.updateColumns.put(column.toUpperCase(), new Column(column));
            }
        }
        return this;
    }

    @Override
    public Run setUpdateColumns(LinkedHashMap<String, Column> columns) {
        this.updateColumns = columns;
        return this;
    }

    @Override
    public Run addCondition(String ... conditions) {
        if (null != conditions) {
            for (String condition : conditions) {
                if (null == condition) continue;
                String up = (condition = condition.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
                if (up.startsWith("ORDER BY")) {
                    String[] orders;
                    String orderStr = condition.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
                    for (String item : orders = orderStr.split(",")) {
                        this.order(item);
                        if (null != this.configs) {
                            this.configs.order(item);
                        }
                        if (null == this.orderStore) continue;
                        this.orderStore.order(item);
                    }
                    continue;
                }
                if (up.startsWith("GROUP BY")) {
                    String[] groups;
                    String groupStr = condition.replaceAll("(?i)group\\s+by", "").trim();
                    if (groupStr.contains(")") || groupStr.contains("'")) {
                        if (null == this.groupStore) {
                            this.groupStore = new DefaultGroupStore();
                        }
                        this.groupStore.group(groupStr);
                        continue;
                    }
                    for (String item : groups = groupStr.split(",")) {
                        if (null == this.groupStore) {
                            this.groupStore = new DefaultGroupStore();
                        }
                        this.groupStore.group(item);
                    }
                    continue;
                }
                if (up.startsWith("HAVING")) {
                    String haveStr;
                    this.having = haveStr = condition.substring(up.indexOf("HAVING") + "HAVING".length()).trim();
                    continue;
                }
                if (BasicUtil.checkEl((String)condition)) {
                    DefaultAutoCondition con = new DefaultAutoCondition(condition.substring(2, condition.length() - 1));
                    this.addCondition(con);
                    continue;
                }
                if (condition.contains(":")) {
                    boolean isTime = false;
                    int idx = condition.indexOf(":");
                    if (condition.indexOf("'") < idx && condition.indexOf("'", idx + 1) > 0) {
                        isTime = true;
                    }
                    if (!isTime) {
                        ParseResult parser = ConfigParser.parse(condition, false);
                        List<Object> value = ConfigParser.getValues(parser);
                        this.addCondition(parser.getSwt(), parser.getCompare(), parser.getPrefix(), parser.getVar(), value, parser.datatype());
                        continue;
                    }
                }
                DefaultAutoCondition con = new DefaultAutoCondition(condition);
                this.addCondition(con);
            }
        }
        return this;
    }

    protected static boolean endWithWhere(String txt) {
        if ((txt = txt.replaceAll("\\s", " ").replaceAll("'[\\S\\s]*?'", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").toUpperCase()).contains("UNION")) {
            boolean result = false;
            int fr = 0;
            while ((fr = txt.indexOf("WHERE")) > 0) {
                if ((txt = txt.substring(fr + 5)).indexOf("UNION") > 0) continue;
                try {
                    int bSize = 0;
                    if (txt.contains(")")) {
                        bSize = RegularUtil.fetch((String)txt, (String)"\\)").size();
                    }
                    int eSize = 0;
                    if (txt.contains("(")) {
                        eSize = RegularUtil.fetch((String)txt, (String)"\\(").size();
                    }
                    if (bSize != eSize) continue;
                    result = true;
                    break;
                }
                catch (Exception e) {
                    log.error("check where exception:", (Throwable)e);
                }
            }
            return result;
        }
        return txt.contains("WHERE");
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public void setVariableBlocks(List<VariableBlock> blocks) {
        this.blocks = blocks;
    }

    @Override
    public boolean isSetValue(String condition, String variable) {
        Variable var;
        Condition con = this.getCondition(condition);
        if (null == con && null != (var = con.getVariable(variable))) {
            return var.isSetValue();
        }
        return false;
    }

    @Override
    public boolean isSetValue(String variable) {
        Variable var = this.getVariable(variable);
        if (null != var) {
            return var.isSetValue();
        }
        return false;
    }

    @Override
    public Variable getVariable(String var) {
        if (null == var) {
            return null;
        }
        for (Variable variable : this.variables) {
            if (null == variable || !var.equalsIgnoreCase(variable.getKey())) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<VariableBlock> getVariableBlocks() {
        return this.blocks;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public TypeMetadata getValueType() {
        return this.valueType;
    }

    public void setValueType(TypeMetadata type) {
        this.valueType = type;
    }

    @Override
    public void setValues(List<RunValue> values) {
        this.values = values;
    }

    @Override
    public Run setQueryColumns(String ... columns) {
        if (null != columns) {
            this.queryColumns = BeanUtil.array2list((Object[][])new String[][]{columns});
        }
        return this;
    }

    @Override
    public Run setQueryColumns(List<String> columns) {
        this.queryColumns = columns;
        return this;
    }

    @Override
    public List<String> getQueryColumns() {
        return this.queryColumns;
    }

    @Override
    public List<String> getExcludeColumns() {
        return this.excludeColumn;
    }

    @Override
    public Run setExcludeColumns(List<String> excludeColumn) {
        this.excludeColumn = excludeColumn;
        return this;
    }

    @Override
    public Run setExcludeColumns(String ... columns) {
        if (null != columns) {
            this.queryColumns = BeanUtil.array2list((Object[][])new String[][]{columns});
        }
        return this;
    }

    @Override
    public Object getFrom() {
        return this.from;
    }

    @Override
    public Run setFrom(Object from) {
        this.from = from;
        return this;
    }

    @Override
    public int getBatch() {
        return this.batch;
    }

    @Override
    public void setBatch(int batch) {
        this.batch = batch;
    }

    @Override
    public int getVol() {
        return this.vol;
    }

    @Override
    public ACTION action() {
        return this.action;
    }

    @Override
    public void action(ACTION action) {
        this.action = action;
    }

    @Override
    public void setVol(int vol) {
        this.vol = vol;
    }

    @Override
    public String getQueryColumn() {
        List<String> cols;
        String result = "*";
        if (null != this.prepare && null != (cols = this.prepare.getFetchKeys()) && !cols.isEmpty()) {
            result = null;
            for (String col : cols) {
                if (null == result) {
                    result = SQLUtil.delimiter((String)col, (String)this.runtime.getAdapter().getDelimiterFr(), (String)this.runtime.getAdapter().getDelimiterTo());
                    continue;
                }
                result = result + "," + SQLUtil.delimiter((String)col, (String)this.runtime.getAdapter().getDelimiterFr(), (String)this.runtime.getAdapter().getDelimiterTo());
            }
        }
        return result;
    }

    protected String replace(String sql) {
        String result = sql;
        if (null != this.values) {
            for (RunValue rv : this.values) {
                DriverAdapter adapter;
                Object value = rv.getValue();
                Column column = rv.getColumn();
                TypeMetadata columnType = null;
                if (null != column) {
                    columnType = column.getTypeMetadata();
                }
                int index = result.indexOf("?");
                String replacement = null;
                if (null == value) {
                    value = "NULL";
                }
                replacement = null != (adapter = this.adapter()) ? adapter.write(this.runtime, column, value, false, false) + "" : (BasicUtil.isNumber((Object)value) || "NULL".equalsIgnoreCase(value.toString()) ? value.toString() : "'" + value + "'");
                result = result.substring(0, index) + replacement + result.substring(index + 1);
            }
        }
        return result;
    }

    @Override
    public String format(String cmd) {
        if (null != cmd) {
            cmd = cmd.replaceAll("\n ", "\n\t").replaceAll("\n\t\n", "\n").replaceAll("\n{2,}", "\n").replaceAll(" {2,}", " ").trim();
        }
        return cmd;
    }

    @Override
    public String log(ACTION.DML action, boolean placeholder) {
        List<Object> values;
        StringBuilder builder = new StringBuilder();
        List<String> keys = null;
        builder.append("[cmd:\n");
        if (action == ACTION.DML.SELECT) {
            builder.append(this.getFinalQuery(placeholder));
        } else if (action == ACTION.DML.COUNT) {
            builder.append(this.getTotalQuery(placeholder));
        } else if (action == ACTION.DML.UPDATE) {
            keys = this.getUpdateColumns();
            builder.append(this.getFinalUpdate(placeholder));
        } else if (action == ACTION.DML.INSERT) {
            keys = this.getInsertColumns();
            builder.append(this.getFinalInsert(placeholder));
        } else if (action == ACTION.DML.EXECUTE) {
            builder.append(this.getFinalExecute(placeholder));
        } else if (action == ACTION.DML.DELETE) {
            builder.append(this.getFinalDelete(placeholder));
        } else if (action == ACTION.DML.EXISTS) {
            builder.append(this.getFinalExists(placeholder));
        }
        builder.append("\n]");
        if (placeholder && null != (values = this.getValues()) && !values.isEmpty()) {
            builder.append("\n[param:");
            builder.append(LogUtil.param(keys, this.getValues()));
            builder.append("];");
        }
        return builder.toString();
    }

    @Override
    public String getTableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return null;
    }

    @Override
    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }

    @Override
    public boolean checkValid() {
        return false;
    }

    @Override
    public Run setUnionAll(boolean all) {
        this.unionAll = all;
        return this;
    }

    @Override
    public boolean isUnionAll() {
        return this.unionAll;
    }

    @Override
    public Run union(Run run, boolean all) {
        run.setUnionAll(all);
        this.unions.add(run);
        return this;
    }

    @Override
    public Run union(Run run) {
        this.unions.add(run);
        return this;
    }

    @Override
    public Run union(List<Run> unions, boolean all) {
        for (Run union : unions) {
            this.union(union, all);
        }
        return this;
    }

    @Override
    public Run union(List<Run> unions) {
        for (Run union : unions) {
            this.union(union);
        }
        return this;
    }

    @Override
    public List<Run> getUnions() {
        return this.unions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.builder.toString();
    }
}

