/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.entity.Join;
import org.anyline.data.param.ConfigBuilder;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.VirtualTablePrepare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OriginRow;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class TableBuilder {
    private RunPrepare prepare = null;
    private boolean distinct = false;
    private ConfigStore conditions = new DefaultConfigStore(new String[0]);
    private LinkedHashMap<String, Column> columns = new LinkedHashMap();
    private List<RunPrepare> joins = new ArrayList<RunPrepare>();

    public RunPrepare build() {
        for (RunPrepare item : this.joins) {
            this.prepare.join(item);
        }
        if (null != this.columns && !this.columns.isEmpty()) {
            this.prepare.getColumns().clear();
            for (Column col : this.columns.values()) {
                this.prepare.addColumn(col);
            }
        }
        if (this.distinct) {
            this.prepare.setDistinct(true);
        }
        this.prepare.condition(this.conditions);
        return this.prepare;
    }

    public static RunPrepare build(String json) {
        Object columns;
        DataSet joins;
        TableBuilder builder = null;
        DataRow row = DataRow.parseJson((String)json);
        Object master = row.get("table");
        String alias = row.getString("alias");
        String distinct = row.getString("distinct");
        if (master instanceof String) {
            Table table = new Table((String)master);
            if (BasicUtil.isNotEmpty((Object)alias)) {
                table.setAlias(alias);
            }
            builder = TableBuilder.init(table);
        }
        if (BasicUtil.isNotEmpty((Object)distinct)) {
            builder.prepare.setDistinct(true);
        }
        if (null != (joins = row.getSet("joins"))) {
            for (DataRow item : joins) {
                String item_table = item.getString("table");
                String item_alias = item.getString("alias");
                String item_join = item.getString("type");
                Join.TYPE join_type = null;
                join_type = BasicUtil.isNotEmpty((Object)item_join) ? Join.TYPE.valueOf(item_join.trim().toUpperCase()) : Join.TYPE.LEFT;
                Join join = new Join();
                join.setType(join_type);
                DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
                Object conditions = item.get("conditions");
                if (conditions instanceof DataRow) {
                    ConfigChain chain = ConfigBuilder.parseConfigChain((DataRow)conditions);
                    configs.setChain(chain);
                    join.setConditions(configs);
                } else if (conditions instanceof String) {
                    join.addConditions((String)conditions);
                } else if (conditions instanceof List) {
                    List list = (List)conditions;
                    for (String con : list) {
                        join.addConditions(con);
                    }
                }
                RunPrepare prepare = null;
                if (item_table instanceof String) {
                    Table item_tab = new Table(item_table);
                    if (BasicUtil.isNotEmpty((Object)item_alias)) {
                        item_tab.setAlias(item_alias);
                    }
                    prepare = new DefaultTablePrepare(item_tab);
                }
                prepare.setJoin(join);
                builder.join(prepare);
            }
        }
        if ((columns = row.get("columns")) instanceof List) {
            List cols = (List)columns;
            for (Object col : cols) {
                if (!(col instanceof String)) continue;
                builder.addColumn((String)col);
            }
        }
        return builder.build();
    }

    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        if ((empty || null != this.prepare) && this.prepare instanceof DefaultTablePrepare) {
            DefaultTablePrepare table = (DefaultTablePrepare)this.prepare;
            row.put("table", (Object)table.getTableName());
            row.put("alias", (Object)table.getTable().getAlias());
            row.put("distinct", (Object)this.prepare.getDistinct());
        }
        if (null != this.joins && !this.joins.isEmpty()) {
            DataSet set = new DataSet();
            for (RunPrepare item : this.joins) {
                set.add(item.map(empty, true));
            }
            row.put("joins", (Object)set);
        }
        if (null != this.columns && !this.columns.isEmpty()) {
            row.put("columns", (Object)Column.names(this.columns.values()));
        } else if (null != this.prepare.getColumns() && !this.prepare.getColumns().isEmpty()) {
            row.put("columns", (Object)Column.names(this.prepare.getColumns().values()));
        }
        return row;
    }

    public String json(boolean empty) {
        return this.map(empty).json();
    }

    public TableBuilder distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public String json() {
        return this.json(false);
    }

    public TableBuilder select(String ... columns) {
        return this.columns(columns);
    }

    public static TableBuilder init() {
        TableBuilder builder = new TableBuilder();
        return builder;
    }

    public static TableBuilder init(String table) {
        return TableBuilder.from(table);
    }

    public static TableBuilder from(String table) {
        return TableBuilder.from(new Table(table));
    }

    public static TableBuilder init(Table table) {
        return TableBuilder.from(table);
    }

    public static TableBuilder from(Table table) {
        TableBuilder builder = new TableBuilder();
        builder.prepare = new DefaultTablePrepare(table);
        return builder;
    }

    public static TableBuilder init(String alias, RunPrepare prepare) {
        return TableBuilder.from(alias, prepare);
    }

    public static TableBuilder from(String alias, RunPrepare prepare) {
        TableBuilder builder = new TableBuilder();
        builder.prepare = new VirtualTablePrepare(prepare).setAlias(alias);
        return builder;
    }

    public static TableBuilder init(String table, String columns) {
        TableBuilder builder = TableBuilder.init(table);
        builder.addColumns(columns);
        return builder;
    }

    public TableBuilder foreign(String column, Table table, String fk, LinkedHashMap<String, String> relations, String ... conditions) {
        String master_alias;
        boolean empty = this.columns.isEmpty();
        String table_alias = table.getAlias();
        if (BasicUtil.isEmpty((Object)table_alias)) {
            table_alias = table.getName();
        }
        if (BasicUtil.isEmpty((Object)(master_alias = this.prepare.getAlias()))) {
            master_alias = this.prepare.getTableName();
        }
        for (String relation : relations.keySet()) {
            String col = table_alias + "." + relation + " AS " + relations.get(relation);
            this.columns.put(col.toUpperCase(), new Column(col));
        }
        if (empty) {
            this.columns.put(master_alias + ".*", new Column(master_alias + ".*"));
        }
        ArrayList<String> cons = new ArrayList<String>();
        cons.add(master_alias + "." + column + " = " + table_alias + "." + fk);
        if (null != conditions) {
            for (String condition : conditions) {
                cons.add(condition);
            }
        }
        this.join(Join.TYPE.LEFT, table, (ConfigStore)new DefaultConfigStore(new String[0]), cons);
        return this;
    }

    public TableBuilder foreign(String column, Table table, String fk, String relation, String alias, String ... conditions) {
        LinkedHashMap<String, String> relations = new LinkedHashMap<String, String>();
        relations.put(relation, alias);
        return this.foreign(column, table, fk, relations, conditions);
    }

    public TableBuilder foreign(String column, String table, String fk, String relation, String alias, String ... conditions) {
        LinkedHashMap<String, String> relations = new LinkedHashMap<String, String>();
        relations.put(relation, alias);
        return this.foreign(column, table, fk, relations, conditions);
    }

    public TableBuilder foreign(String column, String table, String fk, LinkedHashMap<String, String> relations, String ... conditions) {
        return this.foreign(column, new Table(table), fk, relations, conditions);
    }

    public TableBuilder condition(ConfigStore configs) {
        this.conditions = configs;
        return this;
    }

    public TableBuilder addColumn(String column) {
        if (!this.columns.containsKey(column.toUpperCase())) {
            this.columns.put(column.toUpperCase(), new Column(column));
        }
        return this;
    }

    public TableBuilder addColumns(String ... columns) {
        List list = SQLUtil.columns((String[])columns);
        for (String column : list) {
            this.addColumn(column);
        }
        return this;
    }

    public TableBuilder addColumns(List<String> columns) {
        for (String column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public TableBuilder columns(String ... columns) {
        return this.addColumns(columns);
    }

    public TableBuilder columns(List<String> columns) {
        return this.addColumns(columns);
    }

    public TableBuilder setColumns(String ... columns) {
        this.columns = new LinkedHashMap();
        this.addColumns(columns);
        return this;
    }

    public TableBuilder setColumns(List<String> columns) {
        this.columns = new LinkedHashMap();
        this.addColumns(columns);
        return this;
    }

    public TableBuilder join(RunPrepare prepare) {
        this.joins.add(prepare);
        return this;
    }

    public TableBuilder join(String alias, RunPrepare prepare, Join.TYPE type, ConfigStore configs, String ... conditions) {
        Join join = new Join();
        join.setType(type);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (null != conditions) {
            for (String condition : conditions) {
                configs.and(condition);
            }
        }
        join.setConditions(configs);
        return this.join(alias, prepare, join);
    }

    public TableBuilder join(String alias, RunPrepare prepare, Join.TYPE type, String ... conditions) {
        return this.join(alias, prepare, type, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder join(String alias, RunPrepare prepare, Join join) {
        prepare.setJoin(join);
        return this.join(alias, prepare);
    }

    public TableBuilder join(String alias, RunPrepare prepare) {
        this.joins.add(new VirtualTablePrepare(prepare).setAlias(alias));
        return this;
    }

    public TableBuilder join(Join.TYPE type, Table table, ConfigStore configs, String ... conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare(table);
        Join join = new Join();
        join.setType(type);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (null != conditions) {
            for (String condition : conditions) {
                configs.and(condition);
            }
        }
        join.setConditions(configs);
        prepare.setJoin(join);
        this.joins.add(prepare);
        return this;
    }

    public TableBuilder join(Join.TYPE type, Table table, String ... conditions) {
        return this.join(type, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder join(Join.TYPE type, Table table, ConfigStore configs, List<String> conditions) {
        DefaultTablePrepare prepare = new DefaultTablePrepare(table);
        Join join = new Join();
        join.setType(type);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (null != conditions) {
            for (String condition : conditions) {
                configs.and(condition);
            }
        }
        join.setConditions(configs);
        prepare.setJoin(join);
        this.joins.add(prepare);
        return this;
    }

    public TableBuilder join(Join.TYPE type, Table table, List<String> conditions) {
        return this.join(type, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder join(Join.TYPE type, String table, ConfigStore configs, String ... conditions) {
        return this.join(type, new Table(table), configs, conditions);
    }

    public TableBuilder join(Join.TYPE type, String table, String ... conditions) {
        return this.join(type, new Table(table), (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder inner(Table table, String ... conditions) {
        return this.join(Join.TYPE.INNER, table.getFullName(), conditions);
    }

    public TableBuilder inner(Table table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.INNER, table.getFullName(), configs, conditions);
    }

    public TableBuilder inner(String table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.INNER, table, configs, conditions);
    }

    public TableBuilder inner(String table, String ... conditions) {
        return this.join(Join.TYPE.INNER, table, conditions);
    }

    public TableBuilder left(String table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.LEFT, table, configs, conditions);
    }

    public TableBuilder left(String table, String ... conditions) {
        return this.join(Join.TYPE.LEFT, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder left(Table table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.LEFT, table, configs, conditions);
    }

    public TableBuilder left(Table table, String ... conditions) {
        return this.join(Join.TYPE.LEFT, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder right(String table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.RIGHT, table, configs, conditions);
    }

    public TableBuilder right(String table, String ... conditions) {
        return this.join(Join.TYPE.RIGHT, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder right(Table table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.RIGHT, table, configs, conditions);
    }

    public TableBuilder right(Table table, String ... conditions) {
        return this.join(Join.TYPE.RIGHT, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder full(String table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.FULL, table, configs, conditions);
    }

    public TableBuilder full(String table, String ... conditions) {
        return this.join(Join.TYPE.FULL, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder full(Table table, ConfigStore configs, String ... conditions) {
        return this.join(Join.TYPE.FULL, table, configs, conditions);
    }

    public TableBuilder full(Table table, String ... conditions) {
        return this.join(Join.TYPE.FULL, table, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder join(String alias, Join.TYPE type, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        Join join = new Join();
        join.setType(type);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (null != conditions) {
            for (String condition : conditions) {
                configs.and(condition);
            }
        }
        join.setConditions(configs);
        prepare.setJoin(join);
        return this.join(alias, prepare);
    }

    public TableBuilder join(String alias, Join.TYPE type, RunPrepare prepare, ConfigStore configs, List<String> conditions) {
        Join join = new Join();
        join.setType(type);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        if (null != conditions) {
            for (String condition : conditions) {
                configs.and(condition);
            }
        }
        join.setConditions(configs);
        prepare.setJoin(join);
        return this.join(alias, prepare);
    }

    public TableBuilder inner(String alias, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.join(alias, Join.TYPE.INNER, prepare, configs, conditions);
    }

    public TableBuilder inner(String alias, RunPrepare prepare, String ... conditions) {
        return this.join(alias, Join.TYPE.INNER, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder left(String alias, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.join(alias, Join.TYPE.LEFT, prepare, configs, conditions);
    }

    public TableBuilder left(String alias, RunPrepare prepare, String ... conditions) {
        return this.join(alias, Join.TYPE.LEFT, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder right(String alias, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.join(alias, Join.TYPE.RIGHT, prepare, configs, conditions);
    }

    public TableBuilder right(String alias, RunPrepare prepare, String ... conditions) {
        return this.join(alias, Join.TYPE.RIGHT, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }

    public TableBuilder full(String alias, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.join(alias, Join.TYPE.FULL, prepare, configs, conditions);
    }

    public TableBuilder full(String alias, RunPrepare prepare, String ... conditions) {
        return this.join(alias, Join.TYPE.FULL, prepare, (ConfigStore)new DefaultConfigStore(new String[0]), conditions);
    }
}

